/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.presentations.Presentation;

public class AvailableColumnsFormatModel
extends RowPanelModel {
    private Map<Object, RowPanelModel.RowModel> columns = new HashMap<Object, RowPanelModel.RowModel>();
    private int id;
    private Project project;

    public AvailableColumnsFormatModel(Presentation presentation) {
        this.project = presentation.getProject();
        for (Presentation.Column column : presentation.getColumns()) {
            this.columns.put(this.id, new ColumnFormatModel(this.project, column, this.id));
            ++this.id;
        }
    }

    public Iterator<ColumnFormatModel> getAllRows() {
        ArrayList<ColumnFormatModel> columnsList = new ArrayList<ColumnFormatModel>();
        for (RowPanelModel.RowModel model : this.columns.values()) {
            columnsList.add((ColumnFormatModel)model);
        }
        return columnsList.iterator();
    }

    public void addColumn(Presentation.Column column) {
        this.addRow(new ColumnFormatModel(this.project, column, this.id));
        ++this.id;
    }

    @Override
    public RowPanelModel.RowModel getRow(Object id) {
        return this.columns.get(id);
    }

    public void removeColumn(Presentation.Column columnToRemove) {
        Set<Object> set = this.columns.keySet();
        ColumnFormatModel columnModel = null;
        for (Object aSet : set) {
            Integer id = (Integer)aSet;
            columnModel = (ColumnFormatModel)this.columns.get(id);
            if (!columnModel.column.equals(columnToRemove)) continue;
            columnModel = (ColumnFormatModel)this.columns.get(id);
            break;
        }
        if (columnModel != null) {
            this.removeRow(columnModel);
        }
    }

    @Override
    protected void add(RowPanelModel.RowModel rowModel) {
        this.columns.put(rowModel.getId(), rowModel);
    }

    @Override
    protected void remove(RowPanelModel.RowModel rowModel) {
        this.columns.remove(rowModel.getId());
    }

    @Override
    protected void update(Object id, Object value) {
    }

    static class ColumnFormatModel
    implements RowPanelModel.RowModel {
        private Presentation.Column column;
        private Object id;
        private final Project project;

        public ColumnFormatModel(Project project, Presentation.Column column, Object id) {
            this.project = project;
            this.column = column;
            this.id = id;
        }

        @Override
        public String getDescription() {
            return this.column.getLabel(this.project.getDefaultLanguage());
        }

        @Override
        public Object getId() {
            return this.id;
        }

        @Override
        public void setValue(Object value) {
            this.column = (Presentation.Column)value;
        }

        @Override
        public Object getValue() {
            return this.column;
        }
    }
}

