/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.processes.FlowNode;

public class ActivitiesComboModel
extends AbstractListModel
implements ComboBoxModel {
    private List<FlowNode> activitiesList;
    private boolean includeAutomatics;
    private int selectedActivity;
    static final long serialVersionUID = -7063415560378028104L;
    static final long serialCheck = -232128312246725868L;

    public ActivitiesComboModel(InstancesView view, boolean includeAutomatics) {
        this.load(view, includeAutomatics);
        this.includeAutomatics = includeAutomatics;
        this.selectedActivity = -1;
    }

    @Override
    public Object getElementAt(int index) {
        return this.getSize() > 0 ? this.activitiesList.get(index) : null;
    }

    public boolean isEmpty() {
        return this.activitiesList.size() == 0;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedActivity = this.activitiesList.indexOf(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedActivity != -1 && this.activitiesList.size() > this.selectedActivity ? this.activitiesList.get(this.selectedActivity) : null;
    }

    @Override
    public int getSize() {
        return this.activitiesList.size();
    }

    public int findActivityBasedOnName(String name) {
        int result = -1;
        int i = 0;
        for (FlowNode node : this.activitiesList) {
            if (name.equals(node.getId())) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public void reload(InstancesView view) {
        this.load(view, this.includeAutomatics);
        this.fireContentsChanged(this, 0, this.activitiesList.size());
        this.fireIntervalAdded(this, 0, this.activitiesList.size());
    }

    private void load(InstancesView view, boolean includeAutomatics) {
        Sequence nodes = view.getActivities();
        this.activitiesList = new ArrayList<FlowNode>();
        if (nodes == null) {
            return;
        }
    }
}

