/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.rowpanel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class RowPanelModel {
    private List<RowPanelListener> listeners = new ArrayList<RowPanelListener>();

    protected RowPanelModel() {
    }

    public abstract Iterator<? extends RowModel> getAllRows();

    public abstract RowModel getRow(Object var1);

    public final void addRow(RowModel rowModel) {
        this.add(rowModel);
        this.fireRowAdded(rowModel);
    }

    public final void removeRow(RowModel rowModel) {
        this.remove(rowModel);
        this.fireRowRemoved(rowModel);
    }

    protected abstract void add(RowModel var1);

    protected abstract void remove(RowModel var1);

    protected abstract void update(Object var1, Object var2);

    protected void fireRowAdded(RowModel row) {
        for (RowPanelListener listener : this.listeners) {
            listener.rowAdded(row);
        }
    }

    protected void fireRowRemoved(RowModel row) {
        for (RowPanelListener listener : this.listeners) {
            listener.rowRemoved(row);
        }
    }

    void addListener(RowPanelListener listener) {
        this.listeners.add(listener);
    }

    static interface RowPanelListener {
        public void rowAdded(RowModel var1);

        public void rowRemoved(RowModel var1);
    }

    public static interface RowModel {
        public String getDescription();

        public Object getId();

        public void setValue(Object var1);

        public Object getValue();
    }
}

