/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.rowpanel;

import oracle.bpm.designer.view.gui.components.rowpanel.AbstractRowEditorFactory;
import oracle.bpm.designer.view.gui.components.rowpanel.RemovableRowsPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.designer.view.gui.components.rowpanel.StaticRowPanel;
import oracle.bpm.ui.UiContainer;

public class RowPanelBuilder {
    private AbstractRowEditorFactory editorFactory;
    private RowPanelModel model;
    private static final String DEFAULT_HORIZONTAL_GAP = "2dlu";

    public RowPanelBuilder(RowPanelModel model) {
        this.model = model;
    }

    public RowPanelBuilder(RowPanelModel model, AbstractRowEditorFactory editorFactory) {
        this(model);
        this.editorFactory = editorFactory;
    }

    public RowPanel createRemovableRowsPanel(UiContainer parent) {
        return new RemovableRowsPanel(parent, this.buildColumnSpecification(), this.model, this.editorFactory);
    }

    public RowPanel createRowsPanel(UiContainer parent) {
        return new StaticRowPanel(parent, this.buildColumnSpecification(), this.model, this.editorFactory);
    }

    private String buildColumnSpecification() {
        StringBuffer columns = new StringBuffer("2dlu, ");
        columns.append("pref, ");
        columns.append("2dlu, ");
        columns.append("pref, ");
        columns.append("2dlu, ");
        columns.append("pref, ");
        columns.append(DEFAULT_HORIZONTAL_GAP);
        return columns.toString();
    }
}

