/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.rowpanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.view.gui.components.rowpanel.AbstractRowEditorFactory;
import oracle.bpm.designer.view.gui.components.rowpanel.DataChangedEvent;
import oracle.bpm.designer.view.gui.components.rowpanel.DataChangedListener;
import oracle.bpm.designer.view.gui.components.rowpanel.DefaultRowEditorFactory;
import oracle.bpm.designer.view.gui.components.rowpanel.Row;
import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelEvent;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelListener;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public abstract class RowPanel
extends Panel {
    private PanelBuilder builder;
    private CellConstraints constraints;
    private AbstractRowEditorFactory editorFactory;
    private FormLayout layout;
    private List<RowPanelListener> listeners = new ArrayList<RowPanelListener>();
    private RowPanelModel model;
    private Map<Object, Row> rowHash;

    RowPanel(UiContainer parent, String columnSpecification, RowPanelModel rowPanelModel, AbstractRowEditorFactory rowEditorFactory) {
        super(parent);
        if (rowEditorFactory == null) {
            rowEditorFactory = new DefaultRowEditorFactory();
        }
        this.editorFactory = rowEditorFactory;
        this.layout = new FormLayout(columnSpecification);
        this.builder = this.layout.createBuilder((Panel)this);
        this.constraints = this.layout.createCellConstraints();
        this.rowHash = new HashMap<Object, Row>();
        this.model = rowPanelModel;
        this.load();
        this.getModel().addListener(new RowPanelModel.RowPanelListener(){

            @Override
            public void rowAdded(RowPanelModel.RowModel rowModel) {
                RowPanel.this.addRow(rowModel);
            }

            @Override
            public void rowRemoved(RowPanelModel.RowModel row) {
                RowPanel.this.removeRow(row);
            }
        });
    }

    public FormLayout getFormLayout() {
        return this.layout;
    }

    public PanelBuilder getBuilder() {
        return this.builder;
    }

    public CellConstraints getConstraints() {
        return this.constraints;
    }

    public void setEnabled(boolean enabled) {
        for (Row row : this.rowHash.values()) {
            row.setEnabled(enabled);
        }
    }

    public RowPanelModel getModel() {
        return this.model;
    }

    public void addListener(RowPanelListener listener) {
        this.listeners.add(listener);
    }

    protected abstract Row createRow(RowPanelModel.RowModel var1, RowEditor var2);

    protected Map<Object, Row> getRowHash() {
        return this.rowHash;
    }

    protected void addRow(RowPanelModel.RowModel rowModel) {
        RowEditor editor = this.editorFactory.getEditorFor((UiContainer)this, rowModel.getValue());
        editor.setId(rowModel.getId());
        this.addEditingListener(editor);
        Row row = this.createRow(rowModel, editor);
        this.addRowToLayout();
        this.rowHash.put(row.getId(), row);
        row.layoutRow();
        this.revalidate();
        this.repaint();
        this.fireRowAdded(rowModel);
    }

    protected void removeRow(RowPanelModel.RowModel rowModel) {
        Row row = this.getRowHash().get(rowModel.getId());
        this.getRowHash().remove(row.getId());
        row.remove();
        this.fireRowRemoved(rowModel);
        this.revalidate();
        this.getParent().revalidate();
        this.repaint();
    }

    private void fireRowAdded(RowPanelModel.RowModel rowModel) {
        for (RowPanelListener panelListener : this.listeners) {
            panelListener.rowRemoved(new RowPanelEvent(1, rowModel));
        }
    }

    private void fireRowRemoved(RowPanelModel.RowModel rowModel) {
        for (RowPanelListener panelListener : this.listeners) {
            panelListener.rowRemoved(new RowPanelEvent(0, rowModel));
        }
    }

    private void addEditingListener(RowEditor editor) {
        editor.addListener(new DataChangedListener(){

            @Override
            public void dataChanged(DataChangedEvent event) {
                RowPanel.this.model.update(event.getId(), event.getValue());
                RowPanel.this.fireRowUpdated(RowPanel.this.model.getRow(event.getId()));
            }
        });
    }

    private void addRowToLayout() {
        this.layout.appendRow("pref");
    }

    private void fireRowUpdated(RowPanelModel.RowModel rowModel) {
        for (RowPanelListener panelListener : this.listeners) {
            panelListener.rowUpdated(new RowPanelEvent(2, rowModel));
        }
    }

    private void load() {
        for (RowPanelModel.RowModel rowModel : CollectionUtils.each(this.model.getAllRows())) {
            this.addRow(rowModel);
        }
    }
}

