/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.rowpanel;

import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

public class Row {
    private Label description;
    private RowEditor editor;
    private final RowPanel panel;
    private Object rowId;

    public Row(RowPanel rowPanel, RowPanelModel.RowModel model, RowEditor editor) {
        this.panel = rowPanel;
        this.rowId = model.getId();
        this.description = Label.create((UiContainer)this.panel, (Msg)Msg.QUOTE(model.getDescription()));
        this.editor = editor;
    }

    public Object getId() {
        return this.rowId;
    }

    public Object getValue() {
        return this.editor.getValue();
    }

    public void setEnabled(boolean enabled) {
        this.editor.setEnabled(enabled);
    }

    public void layoutRow() {
        int currentRow = this.panel.getFormLayout().getRowCount();
        this.panel.getBuilder().add((UiComponent)this.description, this.panel.getConstraints().xy(4, currentRow));
        this.panel.getBuilder().add(this.editor.getEditor(), this.panel.getConstraints().xy(6, currentRow));
    }

    public void remove() {
        int indexToRemove = this.getIndex();
        this.getPanel().remove((UiComponent)this.getDescription());
        this.getPanel().remove(this.getEditor().getEditor());
        this.getPanel().getFormLayout().removeRow(indexToRemove);
    }

    protected int getIndex() {
        return this.getPanel().getFormLayout().getConstraints((UiComponent)this.description).gridY;
    }

    protected RowPanel getPanel() {
        return this.panel;
    }

    protected RowEditor getEditor() {
        return this.editor;
    }

    protected Label getDescription() {
        return this.description;
    }
}

