/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.rowpanel;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.components.rowpanel.Row;
import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;

public class RemovableRow
extends Row {
    private UiComponent removeButton;

    public RemovableRow(RowPanel rowPanel, final RowPanelModel.RowModel model, RowEditor editor) {
        super(rowPanel, model, editor);
        BaseAction removeAction = new BaseAction(DesignerMsg.REMOVE){

            public void run() {
                RemovableRow.this.getPanel().getModel().removeRow(model);
            }
        };
        this.removeButton = this.createButton((UiContainer)this.getPanel(), removeAction);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.removeButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void layoutRow() {
        int currentRow = this.getPanel().getFormLayout().getRowCount();
        this.getPanel().getBuilder().add(this.removeButton, this.getPanel().getConstraints().xy(2, currentRow));
        super.layoutRow();
    }

    @Override
    public void remove() {
        this.getPanel().remove(this.removeButton);
        super.remove();
    }

    private UiComponent createButton(UiContainer parent, BaseAction action) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add(action);
        return toolBar;
    }
}

