/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.rowpanel;

import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.text.TextField;

public class DefaultRowEditor
extends RowEditor {
    private EditorDelegate delegate;
    private UiComponent editor;

    public DefaultRowEditor(final TextField textField) {
        this.editor = textField;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getValue() {
                return textField.getText();
            }
        };
        textField.addDocumentListener((DocumentListener)this.delegate);
    }

    @Override
    public UiComponent getEditor() {
        return this.editor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editor.setEnabled(false);
    }

    public void setValue(Object value) {
        this.delegate.setValue(value);
    }

    @Override
    public Object getValue() {
        return this.delegate.getValue();
    }

    public abstract class EditorDelegate
    implements ActionListener,
    ItemListener,
    DocumentListener {
        private Object value;

        public abstract void setValue(Object var1);

        public abstract Object getValue();

        public void actionPerformed(ActionEvent e) {
            DefaultRowEditor.this.fireDataChanged(DefaultRowEditor.this.getId(), this.value);
        }

        public void changedUpdate(DocumentEvent e) {
            DefaultRowEditor.this.fireDataChanged(DefaultRowEditor.this.getId(), this.value);
        }

        public void insertUpdate(DocumentEvent e) {
            DefaultRowEditor.this.fireDataChanged(DefaultRowEditor.this.getId(), this.value);
        }

        public void itemStateChanged(ItemEvent e) {
            DefaultRowEditor.this.fireDataChanged(DefaultRowEditor.this.getId(), this.value);
        }

        public void removeUpdate(DocumentEvent e) {
            DefaultRowEditor.this.fireDataChanged(DefaultRowEditor.this.getId(), this.value);
        }
    }
}

