/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.multiplecheckboxpanel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.designer.view.gui.components.multiplecheckboxpanel.MultipleCheckBoxModel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.msg.UIMsg;

public class MultipleCheckBoxPanel
extends Panel {
    private List checkList;
    private int columns;
    private List listeners = new ArrayList();
    private MultipleCheckBoxModel model;

    public MultipleCheckBoxPanel(UiContainer parent, int columns, MultipleCheckBoxModel model) {
        super(parent);
        this.checkList = new ArrayList();
        this.columns = columns;
        this.model = model;
        this.setLayout((Layout)new GridLayout(0, this.columns, 5, 5));
        this.addCheckBoxes();
    }

    public MultipleCheckBoxPanel(UiContainer parent, int columns, MultipleCheckBoxModel model, CheckChangedListener checkChangedListener) {
        this(parent, columns, model);
        this.addListener(checkChangedListener);
    }

    public void setEnabled(boolean enabled) {
        for (UiComponent uiComponent : this.checkList) {
            uiComponent.setEnabled(enabled);
        }
    }

    public void setModel(MultipleCheckBoxModel model) {
        this.model = model;
    }

    public void addListener(CheckChangedListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void fireCheckChanged(CheckChangedEvent event) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((CheckChangedListener)iterator.next()).checkChanged(event);
            }
        }
    }

    public void reload() {
        this.removeAll();
        this.model.update();
        this.addCheckBoxes();
        this.revalidate();
    }

    private void addCheckBoxes() {
        while (this.model.hasNext()) {
            final MultipleCheckBoxModel.CheckBoxModel checkModel = this.model.next();
            CheckBox check = CheckBox.create((UiContainer)this, (Msg)UIMsg.TO_MSG((String)checkModel.getLabel()));
            check.setName(checkModel.getId());
            check.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    checkModel.setValue(e.isStateSelected());
                    MultipleCheckBoxPanel.this.fireCheckChanged(new CheckChangedEvent(e.isStateSelected(), checkModel.getObject()));
                }
            });
            check.setSelected(checkModel.getValue());
            this.checkList.add(check);
        }
    }

    public static class CheckChangedEvent {
        private Object item;
        private boolean selected;

        public CheckChangedEvent(boolean selected, Object item) {
            this.selected = selected;
            this.item = item;
        }

        public Object getItem() {
            return this.item;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }

    public static interface CheckChangedListener {
        public void checkChanged(CheckChangedEvent var1);
    }
}

