/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.format;

import oracle.bpm.designer.view.gui.components.format.AbstractFormatPanel;
import oracle.bpm.designer.view.gui.components.format.FormatChangedEvent;
import oracle.bpm.designer.view.gui.components.format.FormatChangedListener;
import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.ColumnFormatType;

public class FormatRowEditor
extends RowEditor
implements FormatChangedListener {
    private AbstractFormatPanel editor;

    public FormatRowEditor(AbstractFormatPanel formatPanel) {
        this.editor = formatPanel;
        formatPanel.addFormatChangedListener(this);
        formatPanel.load();
    }

    public AbstractFormatPanel getEditor() {
        return this.editor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editor.setEnabled(false);
    }

    public void setValue(Object value) {
        this.editor.setColumn((Presentation.Column)value);
    }

    @Override
    public Object getValue() {
        return this.editor.getColumn();
    }

    @Override
    public void formatChanged(FormatChangedEvent event) {
        ColumnFormatType type;
        Presentation.Column column = this.editor.getColumn();
        column.setColumnFormat(ColumnFormat.getInstance(type, (type = event.getType()).isCustom() ? event.getPattern() : null));
        this.fireDataChanged(this.getId(), column);
    }
}

