/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.format;

import java.util.List;
import java.util.Locale;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.components.format.AbstractFormatPanel;
import oracle.bpm.designer.view.gui.components.format.FormatChangedEvent;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.ColumnFormatType;

public class FormatPanel
extends AbstractFormatPanel {
    private List<ColumnFormatType> formatList;
    private Label formatPreviewLabel;
    private TextField patternTextField;
    private final Project project;

    public FormatPanel(Project project, UiContainer parent, Presentation.Column column, List<ColumnFormatType> formatList) {
        super(parent, column);
        this.project = project;
        this.formatList = formatList;
        this.init();
    }

    @Override
    public void load() {
        ColumnFormat columnFormat = this.column.getColumnFormat();
        if (columnFormat != null) {
            this.updateCombo();
            this.updatePatternTextField(columnFormat);
        } else {
            this.fireFormatChanged(new FormatChangedEvent(this.getType(), this.getPattern()));
        }
    }

    public void translate() {
        super.translate();
        this.formatPreviewLabel.setText(this.getType().getFormatPreview(this.getDefaultLanguage()));
    }

    private void updatePatternTextField(ColumnFormat columnFormat) {
        if (columnFormat.getType().isCustom()) {
            String pattern = columnFormat.getPattern();
            this.patternTextField.setText(pattern);
            this.patternTextField.setEnabled(true);
        }
    }

    private void init() {
        String columns = "20dlu, 75dlu, 5dlu, pref, 10dlu, pref, 10dlu, pref, 5dlu, max(30dlu;pref) ";
        String rows = "5dlu, pref, 5dlu";
        this.setLayout((Layout)new FormLayout(columns, rows));
        CellConstraints cc = new CellConstraints();
        this.add((UiComponent)this.createFormatCombo(), cc.xy(2, 2));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PROPERTY_MASK), cc.xy(4, 2));
        this.add((UiComponent)this.createPatternTextField(), cc.xy(6, 2));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.FORMAT_PREVIEW), cc.xy(8, 2));
        this.add((UiComponent)this.createFormatPreviewLabel(), cc.xy(10, 2));
    }

    private Label createFormatPreviewLabel() {
        String preview = this.getType().getFormatPreview(this.getDefaultLanguage());
        this.formatPreviewLabel = Label.create((UiContainer)this, (Msg)Msg.QUOTE(preview));
        return this.formatPreviewLabel;
    }

    private TextField createPatternTextField() {
        this.patternTextField = new TextField((UiContainer)this, 20);
        this.patternTextField.setEnabled(false);
        this.patternTextField.addDocumentListener((DocumentListener)new PatternDocumentListener());
        return this.patternTextField;
    }

    private ComboBox<ColumnFormatType> createFormatCombo() {
        this.formatCombo = this.createFormatCombo(this.formatList);
        this.updateCombo();
        this.formatCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    boolean custom = ((ColumnFormatType)e.getItem()).isCustom();
                    if (!custom) {
                        FormatPanel.this.patternTextField.setText(null);
                    }
                    FormatPanel.this.patternTextField.setEnabled(custom);
                    FormatPanel.this.updateText();
                    FormatPanel.this.fireFormatChanged(new FormatChangedEvent(FormatPanel.this.getType(), FormatPanel.this.getPattern()));
                }
            }
        });
        return this.formatCombo;
    }

    private void updateText() {
        ColumnFormatType type = this.getType();
        if (type == ColumnFormatType.DATE_CUSTOM) {
            try {
                this.formatPreviewLabel.setText(type.getFormatPreview(this.getDefaultLanguage(), this.getPattern()));
            }
            catch (Throwable throwable) {}
        } else {
            this.formatPreviewLabel.setText(type.getFormatPreview(this.getDefaultLanguage()));
        }
    }

    private Locale getDefaultLanguage() {
        return this.project.getDefaultLanguage();
    }

    private String getPattern() {
        return this.patternTextField.getText();
    }

    private class PatternDocumentListener
    implements DocumentListener {
        private String oldPattern;
        private ColumnFormatType oldType;

        private PatternDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.fireChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.fireChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.fireChange();
        }

        private void fireChange() {
            if (this.oldType == null || !this.oldType.equals(FormatPanel.this.getType()) || !this.oldPattern.equals(FormatPanel.this.getPattern())) {
                FormatPanel.this.updateText();
                FormatPanel.this.fireFormatChanged(new FormatChangedEvent(FormatPanel.this.getType(), FormatPanel.this.getPattern()));
                this.oldType = FormatPanel.this.getType();
                this.oldPattern = FormatPanel.this.getPattern();
            }
        }
    }
}

