/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.format;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.view.gui.components.format.FormatChangedEvent;
import oracle.bpm.designer.view.gui.components.format.FormatChangedListener;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.ColumnFormatType;

public abstract class AbstractFormatPanel
extends Panel {
    protected Presentation.Column column;
    protected ComboBox<ColumnFormatType> formatCombo;
    private ArrayList<FormatChangedListener> listeners;

    protected AbstractFormatPanel(UiContainer parent, Presentation.Column column) {
        super(parent);
        this.column = column;
    }

    public void setColumn(Presentation.Column column) {
        this.column = column;
    }

    public Presentation.Column getColumn() {
        return this.column;
    }

    public void load() {
    }

    public void addFormatChangedListener(FormatChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    protected ComboBox<ColumnFormatType> createFormatCombo(List<ColumnFormatType> formatList) {
        return UiFactory.createComboBox((UiContainer)this, formatList);
    }

    protected void updateCombo() {
        ColumnFormat columnFormat = this.column.getColumnFormat();
        if (columnFormat != null) {
            ColumnFormatType type = columnFormat.getType();
            if (!this.formatCombo.containsItem((Object)type)) {
                this.formatCombo.addItem((Object)type);
            }
            this.formatCombo.setSelectedItem((Object)type);
        }
    }

    protected ColumnFormatType getType() {
        return (ColumnFormatType)this.formatCombo.getSelectedItem();
    }

    protected void fireFormatChanged(FormatChangedEvent event) {
        if (this.listeners != null) {
            for (FormatChangedListener formatChangedListener : this.listeners) {
                formatChangedListener.formatChanged(event);
            }
        }
    }
}

