/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.BetweenTimeChangedListener;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.IntervalChangedListener;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.SingleAndBetweenConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.TimeChangedListener;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedListener;

public class TimeConditionPanel
extends SingleAndBetweenConditionPanel {
    private TimeField calendarTimeField;
    private String defaultEditor;
    private TimeField fromField;
    private IntervalField relativeIntervalField;
    private TimeField toField;
    private static final String CALENDAR_EDITOR = "CALENDAR_EDITOR";
    private static final String RELATIVE_EDITOR = "RELATIVE_EDITOR";

    public TimeConditionPanel(UiContainer parent, FilterAttribute filter) {
        super(parent, filter);
        this.initConditionPanel();
        boolean isAbsolute = filter.getValue() instanceof Time;
        isAbsolute = isAbsolute || filter.getValue().getClass().isArray();
        String string = this.defaultEditor = isAbsolute ? CALENDAR_EDITOR : RELATIVE_EDITOR;
        if (!this.isBetween(filter.getComparison())) {
            this.setEditor(this.defaultEditor);
            this.showProperEditor();
        }
    }

    @Override
    protected void addBetweenEditor(Panel parent) {
        Panel betweenPanel = new Panel((UiContainer)parent);
        betweenPanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.fromField = this.createCalendarEditor(betweenPanel);
        Label.create((UiContainer)betweenPanel, (Msg)DesignerMsg.TO);
        this.toField = this.createCalendarEditor(betweenPanel);
        this.changePanel.add((UiComponent)betweenPanel, (Object)"BETWEEN_EDITOR");
        BetweenTimeChangedListener betweenTimeChangedListener = new BetweenTimeChangedListener(this, this.fromField, this.toField);
        this.fromField.addValueChangedListener((ValueChangedListener)betweenTimeChangedListener);
        this.toField.addValueChangedListener((ValueChangedListener)betweenTimeChangedListener);
    }

    @Override
    protected void addSingleEditor(Panel parent) {
        Panel relativePanel = new Panel((UiContainer)this.changePanel);
        Panel calendarPanel = new Panel((UiContainer)this.changePanel);
        relativePanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        calendarPanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.relativeIntervalField = this.createRelativeEditor((UiContainer)relativePanel);
        this.relativeIntervalField.addValueChangedListener((ValueChangedListener)new IntervalChangedListener(this, this.relativeIntervalField));
        this.calendarTimeField = this.createCalendarEditor(calendarPanel);
        this.calendarTimeField.addValueChangedListener((ValueChangedListener)new TimeChangedListener(this, this.calendarTimeField));
        this.changePanel.add((UiComponent)relativePanel, (Object)RELATIVE_EDITOR);
        this.changePanel.add((UiComponent)calendarPanel, (Object)CALENDAR_EDITOR);
        this.createChangeTypeButton(calendarPanel);
        this.createChangeTypeButton(relativePanel);
    }

    @Override
    protected void loadEditorComponent(Object value) {
        if (CALENDAR_EDITOR.equals(this.getEditor())) {
            Time time = value instanceof Time ? (Time)value : new Time();
            this.calendarTimeField.setTime(time);
        }
        if (RELATIVE_EDITOR.equals(this.getEditor())) {
            Interval interval = value instanceof Interval ? (Interval)value : new Interval();
            this.relativeIntervalField.setInterval(interval);
        }
        if ("BETWEEN_EDITOR".equals(this.getEditor())) {
            Time[] timeArray;
            if (value instanceof Time[]) {
                timeArray = (Time[])value;
            } else {
                Time[] timeArray2 = new Time[2];
                timeArray2[0] = new Time();
                timeArray = timeArray2;
                timeArray2[1] = new Time();
            }
            Time[] times = timeArray;
            this.fromField.setTime(times[0]);
            this.toField.setTime(times[1]);
        }
    }

    @Override
    protected void saveEditorComponent() {
        if (CALENDAR_EDITOR.equals(this.getEditor())) {
            this.filterAttribute.setValue((Object)this.truncateTime(this.calendarTimeField.getTime()));
        }
        if (RELATIVE_EDITOR.equals(this.getEditor())) {
            this.filterAttribute.setValue((Object)this.relativeIntervalField.getInterval());
        }
        if ("BETWEEN_EDITOR".equals(this.getEditor())) {
            Time[] times = new Time[]{this.truncateTime(this.fromField.getTime()), this.truncateTime(this.toField.getTime())};
            this.filterAttribute.setValue((Object)times);
        }
    }

    @Override
    protected void setBetweenEditor(boolean isBetween) {
        this.setEditor(isBetween ? "BETWEEN_EDITOR" : this.defaultEditor);
    }

    private Time truncateTime(Time time) {
        return Time.valueOf(time.getYear(), time.getMonth(), time.getDay(), time.getHourOfDay(), time.getMinute(), time.getSecond());
    }

    private TimeField createCalendarEditor(Panel parent) {
        TimeField timeField = new TimeField((UiContainer)parent);
        timeField.setTime(Time.now());
        return timeField;
    }

    private IntervalField createRelativeEditor(UiContainer parent) {
        Panel relative = new Panel(parent);
        relative.setLayout((Layout)new FlowLayout(0));
        relative.add((UiComponent)Label.create((UiContainer)relative, (Msg)DesignerMsg.NOW));
        IntervalField intervalField = new IntervalField((UiContainer)relative);
        relative.add((UiComponent)intervalField);
        return intervalField;
    }

    private Button createChangeTypeButton(Panel calendarPanel) {
        Button changeButton = new Button((UiContainer)calendarPanel, DesignerMsg.CHANGE_TIME, 10);
        changeButton.setPreferredSize(Dimension.valueOf(20, 20));
        changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimeConditionPanel.this.setEditor(TimeConditionPanel.CALENDAR_EDITOR.equals(TimeConditionPanel.this.getEditor()) ? TimeConditionPanel.RELATIVE_EDITOR : TimeConditionPanel.CALENDAR_EDITOR);
                TimeConditionPanel.this.updateProperEditor();
                if (TimeConditionPanel.CALENDAR_EDITOR.equals(TimeConditionPanel.this.getEditor())) {
                    TimeConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(1, TimeConditionPanel.this.calendarTimeField.getTime()));
                } else {
                    TimeConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(1, TimeConditionPanel.this.relativeIntervalField.getInterval()));
                }
            }
        });
        return changeButton;
    }
}

