/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.view.Comparison;

public abstract class SingleAndBetweenConditionPanel
extends ConditionPanel {
    protected CardLayout cardLayout;
    protected Panel changePanel;
    private String editor;
    protected static final String SINGLE_EDITOR = "SINGLE_EDITOR";
    protected static final String BETWEEN_EDITOR = "BETWEEN_EDITOR";

    protected SingleAndBetweenConditionPanel(UiContainer parent, FilterAttribute filterAttribute) {
        super(parent, filterAttribute);
        this.setBetweenEditor(this.filterAttribute.getComparison());
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    protected abstract void addSingleEditor(Panel var1);

    protected abstract void addBetweenEditor(Panel var1);

    protected abstract void saveEditorComponent();

    @Override
    protected UiComponent getEditorComponent(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.buildMainPanel(mainPanel);
        this.showProperEditor();
        return mainPanel;
    }

    protected void buildMainPanel(Panel mainPanel) {
        this.cardLayout = new CardLayout();
        this.changePanel = new Panel((UiContainer)mainPanel);
        this.changePanel.setLayout((Layout)this.cardLayout);
        this.addSingleEditor(this.changePanel);
        this.addBetweenEditor(this.changePanel);
        mainPanel.add((UiComponent)this.changePanel);
    }

    @Override
    protected void initConditionPanel() {
        super.initConditionPanel();
        this.comparatorCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    SingleAndBetweenConditionPanel.this.setBetweenEditor(e.getItem() == Comparison.BETWEEN || e.getItem() == Comparison.NOT_BETWEEN);
                    SingleAndBetweenConditionPanel.this.updateProperEditor();
                }
            }
        });
    }

    protected void showProperEditor() {
        this.cardLayout.show((UiContainer)this.changePanel, this.getEditor());
    }

    protected void updateProperEditor() {
        this.showProperEditor();
        this.saveEditorComponent();
    }

    protected void setBetweenEditor(boolean isBetween) {
        this.setEditor(isBetween ? BETWEEN_EDITOR : SINGLE_EDITOR);
    }

    protected void setBetweenEditor(Comparison comparison) {
        this.setBetweenEditor(this.isBetween(comparison));
    }

    protected boolean isBetween(Comparison comparison) {
        return comparison == Comparison.BETWEEN || comparison == Comparison.NOT_BETWEEN;
    }

    protected String getEditor() {
        return this.editor;
    }
}

