/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.ParticipantComboBox;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

public class ParticipantConditionPanel
extends ConditionPanel {
    private ProjectListenerAdapter<Participant> listener;
    private ParticipantComboBox participantComboBox;
    private Project project;

    public ParticipantConditionPanel(UiContainer parent, Project project, FilterAttribute filterAttribute) {
        super(parent, filterAttribute);
        this.project = project;
        this.initConditionPanel();
    }

    public Project getProject() {
        return this.project;
    }

    public Class<Participant> getSupportedTypes() {
        return Participant.class;
    }

    @Override
    protected UiComponent getEditorComponent(UiContainer parent) {
        this.participantComboBox = new ParticipantComboBox(parent, this.getProject());
        this.participantComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String value = (String)e.getItem();
                if ("CurrentUser".equals(value)) {
                    ParticipantConditionPanel.this.parametricCheckBox.setEnabled(false);
                } else if (!ParticipantConditionPanel.this.parametricCheckBox.isEnabled()) {
                    ParticipantConditionPanel.this.parametricCheckBox.setEnabled(true);
                }
                ParticipantConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(1, value));
            }
        });
        this.listener = new ProjectListenerAdapter<Participant>(Participant.class){

            public void objectChanged(Participant projectObject, ProjectEvent event) {
                ParticipantConditionPanel.this.participantComboBox.reload();
            }

            public void objectReplaced(Participant oldObject, Participant newObject) {
                ParticipantConditionPanel.this.participantComboBox.reload();
            }

            public void postObjectAdded(Participant object, ProjectObject parent) {
                ParticipantConditionPanel.this.participantComboBox.reload();
            }

            public void postObjectRemoved(Participant object, ProjectObject parent) {
                ParticipantConditionPanel.this.participantComboBox.reload();
            }

            public void preObjectAdded(Participant object, ProjectObject parent) throws ProjectException {
                ParticipantConditionPanel.this.participantComboBox.reload();
            }

            public void preObjectRemoved(Participant object, ProjectObject parent) throws ProjectException {
                ParticipantConditionPanel.this.participantComboBox.reload();
            }
        };
        this.project.addListener(this.listener);
        return this.participantComboBox;
    }

    @Override
    protected void loadEditorComponent(Object value) {
        ((ParticipantComboBox)this.editorComponent).setSelectedItem(value);
    }

    protected void onDispose() {
        this.project.removeListener(this.listener);
    }
}

