/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.BetweenNumericChangedListener;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.SingleAndBetweenConditionPanel;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.NumericField;

public class NumericConditionPanel
extends SingleAndBetweenConditionPanel {
    protected NumericField singleField;
    private boolean acceptDecimals;
    private NumericField fromField;
    private NumericField toField;

    public NumericConditionPanel(UiContainer parent, FilterAttribute attribute) {
        this(parent, attribute, true);
    }

    public NumericConditionPanel(UiContainer parent, FilterAttribute attribute, boolean acceptDecimals) {
        super(parent, attribute);
        this.acceptDecimals = acceptDecimals;
        this.initConditionPanel();
    }

    @Override
    protected void addSingleEditor(Panel parent) {
        Panel container = new Panel((UiContainer)parent);
        container.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.singleField = this.createSingleEditor(container);
        parent.add((UiComponent)container, (Object)"SINGLE_EDITOR");
    }

    @Override
    protected void addBetweenEditor(Panel parent) {
        Panel betweenPanel = new Panel((UiContainer)parent);
        betweenPanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.fromField = this.createSingleField(betweenPanel);
        Label.create((UiContainer)betweenPanel, (Msg)DesignerMsg.TO);
        this.toField = this.createSingleField(betweenPanel);
        this.changePanel.add((UiComponent)betweenPanel, (Object)"BETWEEN_EDITOR");
        BetweenNumericChangedListener betweenNumericChangedListener = new BetweenNumericChangedListener(this, this.fromField, this.toField, this.acceptDecimals);
        this.fromField.addChangeListener((ChangeListener)betweenNumericChangedListener);
        this.toField.addChangeListener((ChangeListener)betweenNumericChangedListener);
    }

    protected NumericField createSingleField(Panel parent) {
        NumericField valueField;
        if (this.acceptDecimals) {
            valueField = NumericField.createDoubleNumericField((UiContainer)parent);
        } else {
            valueField = NumericField.createIntegerNumericField((UiContainer)parent);
            valueField.setScale(0);
        }
        return valueField;
    }

    @Override
    protected void loadEditorComponent(Object value) {
        if (this.getEditor().equals("SINGLE_EDITOR")) {
            Number number = value instanceof Number ? (Number)((Number)value) : (Number)0;
            this.singleField.setValue(number);
        }
        if (this.getEditor().equals("BETWEEN_EDITOR")) {
            Number[] numberArray;
            if (value instanceof Number[]) {
                numberArray = (Number[])value;
            } else {
                Number[] numberArray2 = new Number[2];
                numberArray2[0] = 0;
                numberArray = numberArray2;
                numberArray2[1] = 0;
            }
            Number[] interval = numberArray;
            this.fromField.setValue(interval[0]);
            this.toField.setValue(interval[1]);
        }
    }

    @Override
    protected void saveEditorComponent() {
        if (this.getEditor().equals("SINGLE_EDITOR")) {
            this.filterAttribute.setValue((Object)this.singleField.getValue());
        }
        if (this.getEditor().equals("BETWEEN_EDITOR")) {
            Number[] interval = new Number[]{this.fromField.getValue(), this.toField.getValue()};
            this.filterAttribute.setValue((Object)interval);
        }
    }

    private NumericField<? extends Number> createSingleEditor(Panel container) {
        Object valueField;
        if (this.acceptDecimals) {
            valueField = this.createDoubleNumericField((UiContainer)container);
        } else {
            valueField = this.createIntegerNumericField((UiContainer)container);
            valueField.setScale(0);
        }
        return valueField;
    }
}

