/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.view.gui.components.conditions.ComparatorComboBox;
import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedListener;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.view.Comparison;

public abstract class ConditionPanel
extends Panel {
    protected ComparatorComboBox comparatorCombo;
    protected UiComponent editorComponent;
    protected FilterAttribute filterAttribute;
    protected List<ConditionChangedListener> listeners;
    protected CheckBox parametricCheckBox;

    protected ConditionPanel(UiContainer parent, FilterAttribute filterAttribute) {
        super(parent);
        this.filterAttribute = filterAttribute;
    }

    public void setEnabled(boolean enabled) {
        this.editorComponent.setEnabled(enabled);
        this.comparatorCombo.setEnabled(enabled);
        this.parametricCheckBox.setEnabled(enabled);
    }

    public void setFilterAttribute(FilterAttribute filterAttribute) {
        this.filterAttribute = filterAttribute;
    }

    public FilterAttribute getFilterAttribute() {
        return this.filterAttribute;
    }

    public void addConditionChangedListener(ConditionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConditionChangedListener>();
        }
        this.listeners.add(listener);
    }

    public void loadFilterAttribute() {
        Comparison comparison = this.filterAttribute.getComparison();
        if (comparison != null) {
            this.comparatorCombo.setSelectedItem(comparison);
        } else {
            this.comparatorCombo.setSelectedIndex(0);
            this.filterAttribute.setComparison((Comparison)this.comparatorCombo.getSelectedItem());
        }
        Object value = this.filterAttribute.getValue();
        if (value != null) {
            this.loadEditorComponent(value);
        }
        this.parametricCheckBox.setSelected(this.filterAttribute.isParametric());
    }

    public void fireConditionChanged(ConditionChangedEvent event) {
        if (this.listeners != null) {
            for (ConditionChangedListener listener : this.listeners) {
                listener.conditionChanged(event);
            }
        }
    }

    public String toString() {
        FilterAttribute attribute = this.getFilterAttribute();
        return ((Object)((Object)this)).getClass().getName() + " on variable: " + attribute.getVariableId() + "<Kind='" + attribute.getKind() + "', Comparision='" + attribute.getComparison() + "', Value='" + attribute.getValue() + "'>";
    }

    protected abstract UiComponent getEditorComponent(UiContainer var1);

    protected abstract void loadEditorComponent(Object var1);

    protected void initConditionPanel() {
        String cols = "max(80dlu;pref), 5dlu, max(160dlu;pref), 5dlu, pref, 5dlu";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.comparatorCombo = new ComparatorComboBox((UiContainer)this, this.filterAttribute.getVariable());
        this.comparatorCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    ConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(0, e.getItem()));
                }
            }
        });
        builder.add((UiComponent)this.comparatorCombo, cc.xy(1, 1));
        this.editorComponent = this.getEditorComponent((UiContainer)this);
        builder.add(this.editorComponent, cc.xy(3, 1));
        this.parametricCheckBox = this.createParametricCheckBox((UiContainer)this);
        builder.add((UiComponent)this.parametricCheckBox, cc.xy(5, 1));
        this.loadFilterAttribute();
    }

    protected NumericField<Integer> createIntegerNumericField(UiContainer parent) {
        NumericField valueField = NumericField.createIntegerNumericField((UiContainer)parent);
        this.initField(valueField, 0);
        return valueField;
    }

    protected NumericField<Double> createDoubleNumericField(UiContainer parent) {
        NumericField valueField = NumericField.createDoubleNumericField((UiContainer)parent);
        this.initField(valueField, 0.0);
        return valueField;
    }

    protected CheckBox createParametricCheckBox(UiContainer parent) {
        CheckBox parametricCheckBox = CheckBox.create((UiContainer)parent, (Msg)ProjectMsg.IS_PARAMETRIC);
        parametricCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(2, e.isStateSelected()));
            }
        });
        return parametricCheckBox;
    }

    protected TextField createTextField(UiContainer parent) {
        final TextField valueTextField = new TextField(parent, "");
        valueTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            @Override
            Object getValue() {
                return valueTextField.getText();
            }
        });
        return valueTextField;
    }

    private <E extends Number> void initField(final NumericField<E> valueTextField, E initValue) {
        valueTextField.setValue(initValue);
        valueTextField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(1, valueTextField.getValue()));
            }
        });
    }

    private abstract class DocumentAdapter
    implements DocumentListener {
        private Object oldValue;

        private DocumentAdapter() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.fireChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.fireChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.fireChange();
        }

        abstract Object getValue();

        private void fireChange() {
            if (this.oldValue == null || !this.oldValue.equals(this.getValue())) {
                ConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(1, this.getValue()));
                this.oldValue = this.getValue();
            }
        }
    }
}

