/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.lang.Time;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;

public class BetweenTimeChangedListener
implements ValueChangedListener {
    private final ConditionPanel conditionPanel;
    private final TimeField fromField;
    private final TimeField toField;

    public BetweenTimeChangedListener(ConditionPanel conditionPanel, TimeField fromField, TimeField toField) {
        this.conditionPanel = conditionPanel;
        this.fromField = fromField;
        this.toField = toField;
    }

    public void valueChanged(ValueChangedEvent event) {
        this.conditionPanel.fireConditionChanged(new ConditionChangedEvent(1, this.getBetweenValue()));
    }

    private Time[] getBetweenValue() {
        Time[] result = new Time[]{this.fromField.getTime(), this.toField.getTime()};
        if (!this.isGreaterThan(result[1], result[0])) {
            result[1] = result[0];
        }
        return result;
    }

    private boolean isGreaterThan(Time from, Time to) {
        return from.getMicroSeconds() > to.getMicroSeconds();
    }
}

