/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.text.NumericField;

public class BetweenNumericChangedListener
implements ChangeListener {
    private final boolean acceptDecimals;
    private final NumericField fromField;
    private final ConditionPanel panel;
    private final NumericField toField;

    public BetweenNumericChangedListener(ConditionPanel panel, NumericField fromField, NumericField toField, boolean acceptDecimals) {
        this.panel = panel;
        this.fromField = fromField;
        this.toField = toField;
        this.acceptDecimals = acceptDecimals;
    }

    public void stateChanged(ChangeEvent e) {
        this.panel.fireConditionChanged(new ConditionChangedEvent(1, this.getBetweenValue()));
    }

    private Number[] getBetweenValue() {
        Number[] result = new Number[]{this.fromField.getValue(), this.toField.getValue()};
        if (!this.isGreaterThan(result[1], result[0])) {
            result[1] = result[0];
        }
        return result;
    }

    private boolean isGreaterThan(Number from, Number to) {
        if (this.acceptDecimals) {
            return from.doubleValue() > to.doubleValue();
        }
        return from.intValue() > to.intValue();
    }
}

