/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions.editorpanels;

import oracle.bpm.designer.view.gui.components.ActivitiesCombo;
import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.view.ViewType;

public class ActivityConditionPanel
extends ConditionPanel {
    private ProcessListener processListener;
    private InstancesView view;

    public ActivityConditionPanel(UiContainer parent, FilterAttribute filterAttribute, InstancesView view) {
        super(parent, filterAttribute);
        this.view = view;
        super.initConditionPanel();
    }

    public void onDispose() {
        this.view.removeRelationObserver("process", (ObjectRelationListener)this.processListener);
    }

    @Override
    protected UiComponent getEditorComponent(UiContainer parent) {
        boolean includeAutomatics = this.view.getType().equals(ViewType.ACTIVITY_INSTANCES) || this.view.getType().equals(ViewType.INSTANCES);
        ActivitiesCombo activitiesCombo = new ActivitiesCombo(parent, this.view, includeAutomatics);
        activitiesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FlowNode node = (FlowNode)e.getItem();
                ActivityConditionPanel.this.fireConditionChanged(new ConditionChangedEvent(1, node != null ? node.getId() : null));
            }
        });
        this.processListener = new ProcessListener(activitiesCombo);
        this.view.addRelationObserver("process", (ObjectRelationListener)this.processListener);
        return activitiesCombo;
    }

    @Override
    protected void loadEditorComponent(Object value) {
        ((ActivitiesCombo)this.editorComponent).setSelectedActivityBasedOnName((String)value);
    }

    private final class ProcessListener
    implements ObjectRelationListener {
        private final ActivitiesCombo activitiesCombo;

        public ProcessListener(ActivitiesCombo activitiesCombo) {
            this.activitiesCombo = activitiesCombo;
        }

        @Override
        public void relationAdded(Object object, String relationName) {
            this.activitiesCombo.reload(ActivityConditionPanel.this.view);
        }

        @Override
        public void relationRemoved(Object object, String relationName) {
            this.activitiesCombo.reload(ActivityConditionPanel.this.view);
        }
    }
}

