/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.Participant;

public class ParticipantComboModel
extends AbstractListModel
implements ComboBoxModel {
    private List<String> participantList;
    private final Project project;
    private int selectedParticipant;
    static final long serialVersionUID = 6022606402877071941L;
    static final long serialCheck = 4039358656982285635L;

    public ParticipantComboModel(Project project) {
        this.project = project;
        this.participantList = new ArrayList<String>();
        this.load();
    }

    public void reload() {
        this.participantList.clear();
        this.load();
        this.fireContentsChanged(this, 0, this.participantList.size());
        this.fireIntervalAdded(this, 0, this.participantList.size());
    }

    @Override
    public Object getElementAt(int index) {
        return this.participantList.get(index);
    }

    public boolean isEmpty() {
        return this.participantList.size() == 0;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedParticipant = this.participantList.indexOf(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedParticipant != -1 && this.participantList.size() != 0 ? this.participantList.get(this.selectedParticipant) : null;
    }

    @Override
    public int getSize() {
        return this.participantList.size();
    }

    private void load() {
        this.participantList.add(" ");
        this.participantList.add("CurrentUser");
        Sequence participantProfiles = this.project.getViewManager().getParticipants();
        for (Participant participant : participantProfiles) {
            this.participantList.add(participant.getId());
        }
    }
}

