/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions;

import oracle.bpm.designer.view.gui.components.conditions.ConditionRowEditor;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ActivityConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.BooleanConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.NumericConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ParticipantConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.PriorityConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.StatusConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.StringConditionPanel;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.TimeConditionPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.AbstractRowEditorFactory;
import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.ui.UiContainer;

public class ConditionRowEditorFactory
extends AbstractRowEditorFactory {
    private InstancesView view;

    public ConditionRowEditorFactory(InstancesView view) {
        this.view = view;
    }

    @Override
    public RowEditor getEditorFor(UiContainer parent, Object value) {
        FilterAttribute filter = (FilterAttribute)value;
        String id = filter.getVariableId();
        ConditionPanel conditionPanel = null;
        Project project = this.view.getProject();
        if (id.equals("PREDEFINE_ACTIVITY")) {
            conditionPanel = new ActivityConditionPanel(parent, filter, this.view);
        } else if (id.equals("PREDEFINE_PARTICIPANT") || id.equals("PREDEFINE_AUTHOR")) {
            conditionPanel = new ParticipantConditionPanel(parent, project, filter);
        } else if (id.equals("PREDEFINE_PRIORITY")) {
            conditionPanel = new PriorityConditionPanel(parent, filter);
        } else if (id.equals("PREDEFINE_STATUS")) {
            conditionPanel = new StatusConditionPanel(parent, filter);
        } else {
            switch (filter.getVariable().getType().getKind()) {
                case 1: {
                    conditionPanel = new BooleanConditionPanel(parent, filter);
                    break;
                }
                case 4: {
                    conditionPanel = new NumericConditionPanel(parent, filter);
                    break;
                }
                case 3: {
                    conditionPanel = new NumericConditionPanel(parent, filter);
                    break;
                }
                case 2: {
                    conditionPanel = new NumericConditionPanel(parent, filter, false);
                    break;
                }
                case 5: {
                    conditionPanel = new StringConditionPanel(parent, filter);
                    break;
                }
                case 6: {
                    conditionPanel = new TimeConditionPanel(parent, filter);
                }
            }
        }
        ConditionRowEditor conditionRowEditor = new ConditionRowEditor(conditionPanel);
        return conditionRowEditor;
    }
}

