/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions;

import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedEvent;
import oracle.bpm.designer.view.gui.components.conditions.ConditionChangedListener;
import oracle.bpm.designer.view.gui.components.conditions.editorpanels.ConditionPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowEditor;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.view.Comparison;

public class ConditionRowEditor
extends RowEditor
implements ConditionChangedListener {
    private ConditionPanel editor;

    public ConditionRowEditor(ConditionPanel conditionEditorPanel) {
        this.editor = conditionEditorPanel;
        conditionEditorPanel.addConditionChangedListener(this);
        conditionEditorPanel.loadFilterAttribute();
    }

    @Override
    public UiComponent getEditor() {
        return this.editor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editor.setEnabled(false);
    }

    public void setValue(Object value) {
        this.editor.setFilterAttribute((FilterAttribute)value);
    }

    @Override
    public Object getValue() {
        return this.editor.getFilterAttribute();
    }

    @Override
    public void conditionChanged(ConditionChangedEvent e) {
        FilterAttribute filterAttribute = this.editor.getFilterAttribute();
        Object value = e.getValue();
        switch (e.getType()) {
            case 0: {
                filterAttribute.setComparison((Comparison)value);
                break;
            }
            case 1: {
                filterAttribute.setValue(value);
                break;
            }
            case 2: {
                filterAttribute.setParametric(((Boolean)value).booleanValue());
            }
        }
        this.fireDataChanged(this.getId(), filterAttribute);
    }
}

