/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components.conditions;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.view.Comparison;

public class ComparatorListProvider {
    public static List<Comparison> getComparatorList(ProjectDataObject varDefinition) {
        List<Object> result = new ArrayList();
        String id = varDefinition.getId();
        int kind = varDefinition.getType().getKind();
        if (id.equals("PREDEFINE_ACTIVITY")) {
            result = ComparatorListProvider.getActivityComparatorList();
        } else if (id.equals("PREDEFINE_PRIORITY")) {
            result = ComparatorListProvider.getPriorityComparatorList();
        } else if (id.equals("PREDEFINE_STATUS")) {
            result = ComparatorListProvider.getStatusComparatorList();
        } else if (id.equals("PREDEFINE_PARTICIPANT") || id.equals("PREDEFINE_AUTHOR")) {
            result = ComparatorListProvider.getParticipantComparatorList();
        } else {
            switch (kind) {
                case 2: 
                case 3: 
                case 4: {
                    result = ComparatorListProvider.getIntComparatorList();
                    break;
                }
                case 1: {
                    result = ComparatorListProvider.getBooleanComparatorList();
                    break;
                }
                case 5: {
                    result = ComparatorListProvider.getStringComparatorList();
                    break;
                }
                case 6: 
                case 7: {
                    result = ComparatorListProvider.getTimeComparatorList();
                }
            }
        }
        return result;
    }

    private static List<Comparison> getActivityComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        return result;
    }

    private static List<Comparison> getBooleanComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        return result;
    }

    private static List<Comparison> getIntComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        result.add(Comparison.LESS_THAN);
        result.add(Comparison.GREATER_THAN);
        result.add(Comparison.BETWEEN);
        result.add(Comparison.NOT_BETWEEN);
        return result;
    }

    private static List<Comparison> getParticipantComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        return result;
    }

    private static List<Comparison> getPriorityComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.GREATER_THAN);
        result.add(Comparison.LESS_THAN);
        return result;
    }

    private static List<Comparison> getStatusComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        return result;
    }

    private static List<Comparison> getStringComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.CONTAINS);
        result.add(Comparison.NOT_CONTAINS);
        result.add(Comparison.BEGIN_WITH);
        result.add(Comparison.END_WITH);
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        return result;
    }

    private static List<Comparison> getTimeComparatorList() {
        ArrayList<Comparison> result = new ArrayList<Comparison>();
        result.add(Comparison.IS);
        result.add(Comparison.IS_NOT);
        result.add(Comparison.BEFORE);
        result.add(Comparison.AFTER);
        result.add(Comparison.BETWEEN);
        result.add(Comparison.NOT_BETWEEN);
        return result;
    }
}

