/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import oracle.bpm.designer.view.gui.models.ProcessComboModel;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.organization.OrganizationalUnitImpl;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class ProcessComboBox
extends ComboBox {
    private Project project;

    public ProcessComboBox(Project project, UiContainer parent) {
        super(parent, false);
        this.project = project;
        this.setModel(new ProcessComboModel(project));
        this.setLabelProvider((LabelProvider)new ProcessLabelProvider());
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public void setSelectedProcess(String deployProcessId) {
        this.setSelectedItem(deployProcessId);
    }

    public void reload() {
        ((ProcessComboModel)this.getModel()).reload();
    }

    static class ProcessLabelProvider
    extends LabelProvider.Default {
        ProcessLabelProvider() {
        }

        public String getText(Object element) {
            String deployment = (String)element;
            String processName = ProcessDeploymentUtils.getProcessNameFromDeploymentId((String)deployment);
            String ou = ProcessDeploymentUtils.getOUFromDeploymentId((String)deployment);
            String label = processName;
            if (!OrganizationalUnitImpl.isRootId((String)ou)) {
                label = label + " (" + ou + ")";
            }
            return label;
        }
    }
}

