/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.util.ArrayUtils;

public class PresentationPreviewPanel
extends PaintCanvas {
    private Presentation presentation;

    public PresentationPreviewPanel(UiContainer parent, Presentation presentation) {
        super(parent);
        this.presentation = presentation;
        this.setPreferredSize(Dimension.valueOf(200, 20));
        this.setSize(this.getPreferredSize());
    }

    public void setPresentation(Presentation presentation) {
        this.presentation = presentation;
    }

    public void drawTable() {
        this.repaint();
    }

    public void paintCanvas(Graphics graphics) {
        String label;
        Presentation.Column[] columns = this.presentation.getColumns();
        columns = ArrayUtils.trim(columns);
        int totalSize = 0;
        for (Presentation.Column column : columns) {
            totalSize += column.getSize();
        }
        double columnSizeIfCero = 0.0;
        if (columns.length != 0 && totalSize == 0) {
            columnSizeIfCero = 100 / columns.length;
        }
        int width = this.getSize().getWidth() - 20;
        double totalPercentage = 0.0;
        int x = 0;
        graphics.setFont(graphics.getFont().resize(9));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int[] minColumnPixels = new int[columns.length];
        int[] columnPixels = new int[columns.length];
        int extraSpace = 0;
        for (int i = 0; i < columns.length; ++i) {
            double columnSize;
            Presentation.Column column = columns[i];
            if (totalSize == 0) {
                columnSize = columnSizeIfCero;
            } else {
                columnSize = column.getSize() * 100 / totalSize;
                totalPercentage += columnSize;
                if (column == columns[columns.length - 1]) {
                    columnSize += 100.0 - totalPercentage;
                }
            }
            label = column.getLabel(this.presentation.getProject().getDefaultLanguage());
            int columnSizePixels = (int)((double)width * columnSize / 100.0);
            int charWidthPixels = fontMetrics.charsWidth(label.toCharArray(), 0, label.length()) + 4;
            if (charWidthPixels > columnSizePixels) {
                extraSpace += charWidthPixels - columnSizePixels;
                columnSizePixels = charWidthPixels;
            }
            minColumnPixels[i] = charWidthPixels;
            columnPixels[i] = columnSizePixels;
        }
        boolean spaceAssigned = true;
        while (extraSpace > 0 && spaceAssigned) {
            spaceAssigned = false;
            for (int i = 0; i < columnPixels.length && extraSpace > 0; ++i) {
                int availableSpace = columnPixels[i] - minColumnPixels[i];
                if (availableSpace < 1) continue;
                int n = i;
                columnPixels[n] = columnPixels[n] - 1;
                --extraSpace;
                spaceAssigned = true;
            }
        }
        int height = 18;
        for (int i = 0; i < columns.length; ++i) {
            Presentation.Column column = columns[i];
            label = column.getLabel(this.presentation.getProject().getDefaultLanguage());
            int pixels = columnPixels[i];
            this.drawLabel(label, x, pixels, height, graphics);
            x += pixels;
        }
        if (extraSpace > 0) {
            this.drawLabel("...", this.getSize().getWidth() - 15, 15, height, graphics);
        }
    }

    private void drawLabel(String label, int x, int width, int height, Graphics graphics) {
        graphics.setForeground(Color.valueOf((int)138, (int)167, (int)206));
        graphics.fillRect(x, 0, width, height);
        graphics.setForeground(Color.WHITE);
        graphics.drawRect(x, 0, width, height);
        graphics.drawString(label, x + 2, 12);
    }
}

