/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import oracle.bpm.designer.view.gui.components.PresentationLabelProvider;
import oracle.bpm.designer.view.gui.models.PresentationPreviewComboModel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class PresentationPreviewCombo<E extends Presentation>
extends ComboBox {
    private ViewContainerPanel container;
    private ProjectListenerAdapter<Presentation> listener;
    private PresentationPreviewComboModel presentationPreviewComboModel;
    private Project project;

    public PresentationPreviewCombo(UiContainer parent, Project project, ViewContainerPanel container) {
        super(parent, false);
        this.project = project;
        this.container = container;
        this.presentationPreviewComboModel = new PresentationPreviewComboModel(this.project);
        this.setModel(this.presentationPreviewComboModel);
        this.setLabelProvider((LabelProvider)new PresentationLabelProvider());
        this.listener = new ProjectListenerAdapter<Presentation>(Presentation.class){

            public void postObjectAdded(Presentation object, ProjectObject parent) {
                PresentationPreviewCombo.this.refreshComboItems();
            }

            public void postObjectRemoved(Presentation object, ProjectObject parent) {
                PresentationPreviewCombo.this.refreshComboItems();
            }
        };
        this.project.addListener(this.listener);
    }

    public Presentation getSelectedPresentation() {
        return (Presentation)super.getSelectedItem();
    }

    public Class<Presentation> getSupportedTypes() {
        return Presentation.class;
    }

    public void dispose() {
        this.project.removeListener(this.listener);
        if (this.isRecyclable()) {
            super.dispose();
        }
    }

    private void refreshComboItems() {
        Object selectedItem = this.getSelectedItem();
        this.presentationPreviewComboModel.reload();
        this.setModel(this.presentationPreviewComboModel);
        this.setSelectedItem(selectedItem);
        this.container.setDirty(false);
    }
}

