/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.view.gui.models.LocalesComboModel;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class LocalesComboBox
extends ComboBox {
    private View view;

    public LocalesComboBox(UiContainer parent, LocalesComboModel localesComboModel) {
        super(parent, false);
        this.setModel(localesComboModel);
        this.setLabelProvider((LabelProvider)new LocaleLabelProvider());
        this.setSelectedIndex(0);
    }

    public void reload() {
        LocalesComboModel model = (LocalesComboModel)this.getModel();
        model.reload();
        this.filter();
        this.setEnabled(!model.isEmpty());
        this.updateUI();
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public Locale getSelectedLocale() {
        return (Locale)this.getSelectedItem();
    }

    public void setUsedLocalesFilter(View view) {
        this.view = view;
        this.filter();
    }

    public void setUsedLocale(Locale locale, boolean used) {
        LocalesComboModel localesComboModel = (LocalesComboModel)this.getModel();
        localesComboModel.setLocaleUsed(locale, used);
        if (!this.isEnabled() && !used) {
            this.setEnabled(true);
        }
        if (localesComboModel.isEmpty()) {
            this.setEnabled(false);
        } else {
            this.setSelectedIndex(0);
        }
    }

    private void filter() {
        LocaleStringMap labels = this.view.getLabels();
        for (Locale locale : labels.keySet()) {
            this.setUsedLocale(locale, true);
        }
    }

    private static class LocaleLabelProvider
    extends LabelProvider.Default {
        private LocaleLabelProvider() {
        }

        public String getText(Object element) {
            String result;
            if (element instanceof Locale) {
                Locale locale = (Locale)element;
                result = locale.getDisplayName(locale);
            } else {
                result = String.valueOf(element);
            }
            return result;
        }
    }
}

