/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.HtmlViewer;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public abstract class HtmlPreviewPanel
extends Panel {
    private HtmlViewer htmlViewer;
    private static final String TABLE_START = "<html><body>";
    private static final String TABLE_END = "</body></html>";

    public HtmlPreviewPanel(UiContainer parent) {
        super(parent);
        ScrollPane scrollablePreview = new ScrollPane((UiContainer)this, ScrollPolicy.NEVER, ScrollPolicy.AS_NEEDED);
        this.htmlViewer = new HtmlViewer((UiContainer)scrollablePreview);
        scrollablePreview.setView((UiComponent)this.htmlViewer);
        this.drawTable();
        Dimension preferredSize = scrollablePreview.getPreferredSize();
        scrollablePreview.setPreferredSize(Dimension.valueOf(preferredSize.getWidth(), preferredSize.getHeight() + 10));
        scrollablePreview.setBorder(null);
        this.setLayout((Layout)new BorderLayout());
        this.add((UiComponent)scrollablePreview, "Center");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.htmlViewer.setEnabled(enabled);
    }

    public void setToolTipText(String tooltip) {
        super.setToolTipText(tooltip);
        this.htmlViewer.setToolTipText(tooltip);
    }

    public void drawTable() {
        StringBuffer newTable = new StringBuffer(TABLE_START);
        newTable.append(this.createCells());
        newTable.append(TABLE_END);
        this.htmlViewer.setText(newTable.toString());
        this.htmlViewer.repaint();
    }

    protected abstract String createCells();
}

