/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import java.util.Locale;
import oracle.bpm.designer.view.gui.models.ConditionsComboModel;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class ConditionsComboBox
extends ComboBox<ProjectDataObject> {
    public ConditionsComboBox(UiContainer parent, InstancesView view) {
        super(parent, false);
        this.setModel(new ConditionsComboModel(view));
        this.setLabelProvider((LabelProvider)new ConditionsLabelProvider());
    }

    public void reload(InstancesView view) {
        int oldIndex = this.getSelectedIndex();
        this.setModel(new ConditionsComboModel(view));
        this.setSelectedIndex(oldIndex);
        this.repaint();
    }

    public static class ConditionsLabelProvider
    extends LabelProvider.Default<ProjectDataObject> {
        public String getText(ProjectDataObject dataObject) {
            String label = dataObject.getLabelMap().getString(Locale.getDefault());
            return label == null || label.trim().length() == 0 ? dataObject.getId() : label;
        }
    }
}

