/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.components;

import oracle.bpm.designer.view.gui.models.ActivitiesComboModel;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class ActivitiesCombo
extends ComboBox<FlowNode> {
    public ActivitiesCombo(UiContainer parent, InstancesView view, boolean includeAutomatics) {
        super(parent, false);
        this.setModel(new ActivitiesComboModel(view, includeAutomatics));
        this.setLabelProvider((LabelProvider)new ActivityLabelProvider());
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public FlowNode getSelectedActivity() {
        return (FlowNode)this.getSelectedItem();
    }

    public void setSelectedActivityBasedOnName(String name) {
        this.setSelectedIndex(((ActivitiesComboModel)this.getModel()).findActivityBasedOnName(name));
    }

    public void reload(InstancesView view) {
        ((ActivitiesComboModel)this.getModel()).reload(view);
    }

    static class ActivityLabelProvider
    extends LabelProvider.Default<FlowNode> {
        ActivityLabelProvider() {
        }

        public String getText(FlowNode flowNode) {
            Process process = flowNode.getProcess();
            String text = process.getDefaultLabel() + "." + flowNode.getDefaultLabel();
            return text;
        }
    }
}

