/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui;

import oracle.bpm.designer.view.gui.panels.ViewFilterAttributesPanel;
import oracle.bpm.designer.view.gui.panels.ViewPanelComponentFactory;
import oracle.bpm.designer.view.gui.panels.ViewPanelDelegator;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.ApplicationsView;
import oracle.bpm.project.model.presentation.views.AttachmentsView;
import oracle.bpm.project.model.presentation.views.FolderView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.view.ViewType;

public class ViewPanelBuilderOld {
    public static ViewPanelDelegator buildViewPanel(UiContainer viewPanel, View view, ViewPanelComponentFactory componentFactory) {
        ViewType viewType = view.getType();
        Panel panel = null;
        switch (viewType) {
            case ACTIVITY_INSTANCES: {
                panel = ViewPanelBuilderOld.buildActivityInstancesViewPanel(viewPanel, (ActivityView)view, componentFactory);
                break;
            }
            case INSTANCES: {
                panel = ViewPanelBuilderOld.buildInstancesViewPanel(viewPanel, (InstancesView)view, componentFactory);
                break;
            }
            case FOLDER: {
                panel = ViewPanelBuilderOld.buildFolderViewPanel(viewPanel, (FolderView)view, componentFactory);
                break;
            }
            case ATTACHMENTS: {
                panel = ViewPanelBuilderOld.buildAttachmentsViewPanel(viewPanel, (AttachmentsView)view, componentFactory);
                break;
            }
            case APPLICATIONS: {
                panel = ViewPanelBuilderOld.buildApplicationsViewPanel(viewPanel, (ApplicationsView)view, componentFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("ViewType " + viewType + " from view " + view + " does not have an associated view panel.");
            }
        }
        viewPanel.add((UiComponent)panel, (Object)"Center");
        return (ViewPanelDelegator)panel;
    }

    private static Panel buildActivityInstancesViewPanel(UiContainer viewPanel, ActivityView view, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        Panel headerPanel = componentFactory.createHeaderPanel((UiContainer)panel);
        builder.add((UiComponent)headerPanel, cc.xy(2, 2));
        Panel rolesPanel = componentFactory.createRolesPanel((UiContainer)panel);
        builder.add((UiComponent)rolesPanel, cc.xy(2, 6));
        ViewFilterAttributesPanel filterAttributesPanel = (ViewFilterAttributesPanel)componentFactory.createFilterAttributesPanel((UiContainer)panel, (InstancesView)view);
        builder.add((UiComponent)filterAttributesPanel, cc.xy(2, 18));
        Panel processesPanel = componentFactory.createProcessesAndActivitiesPanel((UiContainer)panel, view, rolesPanel, filterAttributesPanel.getConditionsCombo());
        panel.add((UiComponent)processesPanel, cc.xy(2, 4));
        Panel viewPropertiesPanel = componentFactory.createViewPropertiesPanel((UiContainer)panel);
        builder.add((UiComponent)viewPropertiesPanel, cc.xy(2, 8));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)view), cc.xy(2, 10));
        Panel presentationPanel = componentFactory.createPresentationPanel((UiContainer)panel);
        panel.add((UiComponent)presentationPanel, cc.xy(2, 12));
        panel.add(componentFactory.createIncludeInstancesPanel(panel, (InstancesView)view), cc.xy(2, 14));
        builder.add((UiComponent)componentFactory.createFilterOptionsPanel((UiContainer)panel, (InstancesView)view), cc.xy(2, 16));
        return panel;
    }

    private static Panel buildApplicationsViewPanel(UiContainer viewPanel, ApplicationsView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        Panel headerPanel = componentFactory.createHeaderPanel((UiContainer)panel);
        builder.add((UiComponent)headerPanel, cc.xy(2, 2));
        Panel rolesPanel = componentFactory.createRolesPanel((UiContainer)panel);
        builder.add((UiComponent)rolesPanel, cc.xy(2, 6));
        Panel processesPanel = componentFactory.createProcessesPanel((UiContainer)panel, rolesPanel);
        builder.add((UiComponent)processesPanel, cc.xy(2, 4));
        Panel viewPropertiesPanel = componentFactory.createViewPropertiesPanel((UiContainer)panel);
        builder.add((UiComponent)viewPropertiesPanel, cc.xy(2, 8));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xy(2, 10));
        return panel;
    }

    private static Panel buildAttachmentsViewPanel(UiContainer viewPanel, AttachmentsView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        Panel headerPanel = componentFactory.createHeaderPanel((UiContainer)panel);
        builder.add((UiComponent)headerPanel, cc.xy(2, 2));
        Panel rolesPanel = componentFactory.createRolesPanel((UiContainer)panel);
        builder.add((UiComponent)rolesPanel, cc.xy(2, 6));
        Panel processesPanel = componentFactory.createProcessesPanel((UiContainer)panel, rolesPanel);
        builder.add((UiComponent)processesPanel, cc.xy(2, 4));
        Panel viewPropertiesPanel = componentFactory.createViewPropertiesPanel((UiContainer)panel);
        builder.add((UiComponent)viewPropertiesPanel, cc.xy(2, 8));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xy(2, 10));
        return panel;
    }

    private static Panel buildFolderViewPanel(UiContainer viewPanel, FolderView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        Panel headerPanel = componentFactory.createHeaderPanel((UiContainer)panel);
        builder.add((UiComponent)headerPanel, cc.xy(2, 2));
        Panel rolesPanel = componentFactory.createRolesPanel((UiContainer)panel);
        builder.add((UiComponent)rolesPanel, cc.xy(2, 4));
        Panel viewPropertiesPanel = componentFactory.createViewPropertiesPanel((UiContainer)panel);
        builder.add((UiComponent)viewPropertiesPanel, cc.xy(2, 6));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xy(2, 8));
        return panel;
    }

    private static Panel buildInstancesViewPanel(UiContainer viewPanel, InstancesView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        panel.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        Panel headerPanel = componentFactory.createHeaderPanel((UiContainer)panel);
        panel.add((UiComponent)headerPanel, cc.xy(2, 2));
        Panel rolesPanel = componentFactory.createRolesPanel((UiContainer)panel);
        panel.add((UiComponent)rolesPanel, cc.xy(2, 6));
        ViewFilterAttributesPanel filterAttributesPanel = (ViewFilterAttributesPanel)componentFactory.createFilterAttributesPanel((UiContainer)panel, viewModel);
        panel.add((UiComponent)filterAttributesPanel, cc.xy(2, 18));
        Panel processesPanel = componentFactory.createProcessesPanel(panel, rolesPanel, filterAttributesPanel.getConditionsCombo());
        panel.add((UiComponent)processesPanel, cc.xy(2, 4));
        Panel viewPropertiesPanel = componentFactory.createViewPropertiesPanel((UiContainer)panel);
        panel.add((UiComponent)viewPropertiesPanel, cc.xy(2, 8));
        panel.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xy(2, 10));
        Panel presentationPanel = componentFactory.createPresentationPanel((UiContainer)panel);
        panel.add((UiComponent)presentationPanel, cc.xy(2, 12));
        panel.add(componentFactory.createIncludeInstancesPanel(panel, viewModel), cc.xy(2, 14));
        panel.add((UiComponent)componentFactory.createFilterOptionsPanel((UiContainer)panel, viewModel), cc.xy(2, 16));
        return panel;
    }
}

