/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.designer.view.gui.ViewIconFactory;
import oracle.bpm.designer.view.gui.ViewPanelBuilderOld;
import oracle.bpm.designer.view.gui.ViewPanelComponentFactoryOld;
import oracle.bpm.designer.view.gui.panels.ViewPanelComponentFactory;
import oracle.bpm.designer.view.gui.panels.ViewPanelDelegator;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.presentation.views.ViewAdapter;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

@Editor(objectClass=View.class)
public class ViewPanel
extends AbstractEditor<View> {
    private ViewPanelComponentFactory componentFactory;
    private ViewPanelDelegator containedPanel;

    public ViewPanel(UiContainer parent, ViewAdapter viewAdapter) {
        super(parent, viewAdapter, View.class);
        this.setName(viewAdapter.getId());
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.VIEW;
    }

    public void setEnabled(boolean enabled) {
        this.containedPanel.setEnabled(enabled);
    }

    @Override
    public Image getIcon() {
        Image result = ViewIconFactory.getIcon(((View)this.getProjectObject()).getType());
        if (((View)this.getProjectObject()).isReadOnly()) {
            result = IconFactory.createReadOnly(result);
        }
        return result;
    }

    @Override
    public Object getInput() {
        return this.getProjectObject();
    }

    public void setReadOnly() {
        boolean studioRO = ((View)this.getProjectObject()).isReadOnly();
        this.setReadOnly(studioRO);
        if (studioRO) {
            this.containedPanel.setEnabled(false);
        }
    }

    public String getViewId() {
        return ((View)this.getProjectObject()).getId();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        View view = (View)this.getProjectObject();
        this.setName(view.getId());
        parent.setLayout((Layout)new BorderLayout());
        this.containedPanel = ViewPanelBuilderOld.buildViewPanel(parent, (View)this.getProjectObject(), this.getComponentFactory());
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }

    void synchronize() {
        this.containedPanel.synchronize();
    }

    private ViewPanelComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = new ViewPanelComponentFactoryOld(this);
        }
        return this.componentFactory;
    }
}

