/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewBuilder;
import oracle.bpm.designer.view.gui.components.TypeComboBox;
import oracle.bpm.designer.view.gui.components.TypeRadioPanel;
import oracle.bpm.designer.view.gui.components.TypeSelector;
import oracle.bpm.designer.view.gui.components.ViewChooser;
import oracle.bpm.designer.view.gui.tree.ViewNode;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.exception.ViewAlreadyExistsException;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class ViewCreationPanel
extends Panel {
    private ViewBuilder builder;
    private boolean parentChanged;
    private ViewChooser parentChooser;
    private Project project;
    private UiComponent typeSelector;
    private boolean useCombo;
    private IdentifierTextField viewIdTextField;
    public static final int USE_RADIOS_FOR_TYPE = 1;
    public static final int USE_COMBO_FOR_TYPE = 2;

    public ViewCreationPanel(UiContainer parent, Project project, View parentView) {
        this(parent, project, 2, parentView);
        this.parentChanged = false;
    }

    private ViewCreationPanel(UiContainer parent, Project project, int typeSelector, View parentView) {
        super(parent);
        this.setProject(project);
        this.useCombo = typeSelector == 2;
        this.initGui();
        this.builder = new ViewBuilder(this.getProject());
        if (parentView != null) {
            this.parentChooser.setValue(parentView.getId());
            this.viewIdTextField.setText(project.getViewManager().getDefaultViewId(parentView));
        }
    }

    public Project getProject() {
        return this.project;
    }

    public ViewNode getSelectedParent() {
        return (ViewNode)this.parentChooser.getValueTreeNode();
    }

    public String getViewName() {
        return this.viewIdTextField.getText();
    }

    public View getView() throws ViewAlreadyExistsException {
        return this.builder.createView();
    }

    public boolean isIdEmpty() {
        String text = this.viewIdTextField.getText();
        return text == null || text.equals("");
    }

    public void loadModel() {
        this.builder.setViewType(((TypeSelector)this.typeSelector).getSelectedType());
        this.builder.setViewId(this.viewIdTextField.getText());
        String parentId = this.parentChooser.getValue();
        this.builder.setParentViewId(parentId == null ? "" : parentId);
    }

    public boolean parentChanged() {
        return this.parentChanged;
    }

    public void setProject(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null project");
        }
        this.project = project;
    }

    private void buildParentChooser(UiContainer parent) {
        this.parentChooser = ViewChooser.create(parent, this.getProject());
        this.parentChooser.addNodeSelectedListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ViewCreationPanel.this.parentChanged = true;
            }
        });
    }

    private void initGui() {
        String cols = "10dlu, pref, 5dlu, pref, 5dlu, pref:grow, 10dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 10dlu";
        FormLayout layout = new FormLayout("10dlu, pref, 5dlu, pref, 5dlu, pref:grow, 10dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 10dlu");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        Label viewIdLabel = Label.create((UiContainer)this, (Msg)CoreMsg.ID);
        Label parentViewLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.PARENT);
        Label viewTypeLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TYPE);
        this.viewIdTextField = new IdentifierTextField((UiContainer)this, 25, true);
        this.typeSelector = this.useCombo ? new TypeComboBox((UiContainer)this) : new TypeRadioPanel((UiContainer)this);
        this.buildParentChooser((UiContainer)this);
        this.viewIdTextField.setText(this.project.getViewManager().getDefaultViewId(null));
        builder.add((UiComponent)new SeparatorPanel((UiContainer)this, LibMsg.VIEW), cc.xywh(1, 2, 7, 1));
        builder.add((UiComponent)viewIdLabel, cc.xy(2, 4));
        builder.add((UiComponent)this.viewIdTextField, cc.xywh(4, 4, 3, 1));
        builder.add((UiComponent)parentViewLabel, cc.xy(2, 6));
        builder.add((UiComponent)this.parentChooser, cc.xy(4, 6));
        builder.add((UiComponent)viewTypeLabel, cc.xy(2, 8));
        builder.add(this.typeSelector, cc.xy(4, 8));
    }
}

