/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui;

import java.util.Locale;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.exception.ViewAlreadyExistsException;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.presentation.views.ViewAdapter;
import oracle.bpm.view.ViewType;

public class ViewBuilder {
    private String parentViewId;
    private Project project;
    private String viewId;
    private String viewType;

    public ViewBuilder(Project project) {
        this.project = project;
    }

    public void setParentViewId(String parentViewId) {
        this.parentViewId = parentViewId;
    }

    public Project getProject() {
        return this.project;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public View createView() throws ViewAlreadyExistsException {
        String fullId;
        String string = fullId = this.parentViewId != null && !this.parentViewId.equals("") ? this.parentViewId + "/" + this.viewId : this.viewId;
        if (this.getProject().getViewManager().containsView(fullId)) {
            throw new ViewAlreadyExistsException(this.getProject().getViewManager().getView(fullId));
        }
        View view = ViewAdapter.create((ViewType)ViewType.valueOf(this.viewType), (String)fullId, (Project)this.project);
        view.setLabel(this.viewId, new Locale(Locale.getDefault().getLanguage()));
        return view;
    }
}

