/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.PresentationPanel;
import oracle.bpm.designer.view.gui.components.PresentationPreviewPanel;
import oracle.bpm.designer.view.gui.components.format.FormatRowEditorFactory;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelBuilder;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelEvent;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelListener;
import oracle.bpm.designer.view.gui.models.AbstractColumnsTableModel;
import oracle.bpm.designer.view.gui.models.AvailableColumnsFormatModel;
import oracle.bpm.designer.view.gui.models.AvailableColumnsTableModel;
import oracle.bpm.designer.view.gui.models.SelectedColumnsTableModel;
import oracle.bpm.designer.view.gui.models.SortingColumnsTableModel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;

public class PresentationPanelBuilder {
    private Table availableColumnsTable;
    private DeleteSortingColumnAction deleteOrderingColumnAction;
    private RowPanel formatTable;
    private MoveSelectedColumnDownAction moveColumnDownAction;
    private MoveSelectedColumnUpAction moveColumnUpAction;
    private MoveSortingColumnDownAction moveOrderingColumnDownAction;
    private MoveSortingColumnUpAction moveOrderingColumnUpAction;
    private Presentation presentation;
    private PresentationPanel presentationPanel;
    private PresentationPreviewPanel presentationPreviewPanel;
    private SelectColumnAction selectColumnAction;
    private Table selectedColumnsTable;
    private AddToSortingAction sortingColumnAction;
    private Table sortingTable;
    private UnselectColumnAction unselectColumnAction;

    public PresentationPanelBuilder(Presentation presentation, PresentationPanel presentationPanel) {
        this.presentation = presentation;
        this.presentationPanel = presentationPanel;
    }

    public Panel buildPresentationPanel(UiContainer parent) {
        this.createActions(parent.getParent());
        Panel presentationPanel = new Panel(parent);
        String cols = "5dlu, pref,1dlu:grow(0.5), pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, 1dlu:grow(0.5), 5dlu, pref";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 15dlu, pref, 10dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 25dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(presentationPanel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.createHeaderPanel((UiContainer)presentationPanel), cc.xywh(2, 2, 12, 1));
        builder.add((UiComponent)new SeparatorPanel((UiContainer)presentationPanel, DesignerMsg.PRESENTATION_PREVIEW), cc.xywh(2, 4, 12, 1));
        this.createPresentationPreviewPanel((UiContainer)presentationPanel);
        builder.add((UiComponent)this.presentationPreviewPanel, cc.xywh(3, 6, 11, 1));
        builder.add((UiComponent)Label.create((UiContainer)presentationPanel, (Msg)DesignerMsg.AVAILABLE_COLUMNS), cc.xy(4, 8));
        builder.add((UiComponent)Label.create((UiContainer)presentationPanel, (Msg)DesignerMsg.SELECTED_COLUMNS), cc.xy(8, 8));
        builder.add((UiComponent)Label.create((UiContainer)presentationPanel, (Msg)DesignerMsg.SORTING), cc.xy(12, 8));
        builder.add((UiComponent)this.createAvailableColumnsTable((UiContainer)presentationPanel, this.presentation), cc.xy(4, 10));
        builder.add((UiComponent)this.createAvailableColumnsActions((UiContainer)presentationPanel), cc.xy(6, 10));
        builder.add((UiComponent)this.createSelectedColumnsTable((UiContainer)presentationPanel, this.presentation), cc.xy(8, 10));
        builder.add((UiComponent)this.createSelectedColumnsActions((UiContainer)presentationPanel), cc.xy(10, 10));
        builder.add((UiComponent)this.createSortingColumnsTable(presentationPanel), cc.xy(12, 10));
        builder.add(this.createSortingColumnsActions(presentationPanel), cc.xy(14, 10));
        presentationPanel.add((UiComponent)new SeparatorPanel((UiContainer)presentationPanel, DesignerMsg.COLUMN_FORMAT), (Object)cc.xywh(2, 12, 12, 1));
        presentationPanel.add(this.createFormatTable((UiContainer)presentationPanel, parent.getParent()), (Object)cc.xywh(2, 14, 12, 1));
        boolean readOnly = this.presentation.isReadOnly();
        this.presentationPanel.setReadOnly(readOnly);
        if (readOnly) {
            Utilities.disableChildrenComponentTree((UiComponent)presentationPanel);
        }
        this.selectedColumnsTable.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                SortingColumnsTableModel model = (SortingColumnsTableModel)PresentationPanelBuilder.this.sortingTable.getModel();
                model.reload();
            }
        });
        final Project project = this.presentation.getProject();
        final ProjectListener<DataObject> projectListener = this.createProjectVariablesListener();
        project.addListener(projectListener);
        presentationPanel.addVisibilityListener(new VisibilityListener(){

            public void onDispose() {
                project.removeListener(projectListener);
            }
        });
        return presentationPanel;
    }

    private ProjectListener<DataObject> createProjectVariablesListener() {
        ProjectListenerAdapter<DataObject> projectListener = new ProjectListenerAdapter<DataObject>(DataObject.class){

            public void postObjectAdded(DataObject object, ProjectObject parent) {
                if (this.isProjectVariable(object)) {
                    new UiRunnableDecorator(0, new Runnable(){

                        @Override
                        public void run() {
                            ((AvailableColumnsTableModel)PresentationPanelBuilder.this.availableColumnsTable.getModel()).reload();
                        }
                    }).run();
                }
            }

            public void postObjectRemoved(DataObject object, ProjectObject parent) {
                if (this.isProjectVariable(object)) {
                    new UiRunnableDecorator(0, new Runnable(){

                        @Override
                        public void run() {
                            SortingColumnsTableModel sortingColumnsTableModel = (SortingColumnsTableModel)PresentationPanelBuilder.this.sortingTable.getModel();
                            SelectedColumnsTableModel selectedColumnsTableModel = (SelectedColumnsTableModel)PresentationPanelBuilder.this.selectedColumnsTable.getModel();
                            AvailableColumnsTableModel availableColumnsTableModel = (AvailableColumnsTableModel)PresentationPanelBuilder.this.availableColumnsTable.getModel();
                            sortingColumnsTableModel.reload();
                            selectedColumnsTableModel.reload();
                            availableColumnsTableModel.reload();
                        }
                    }).run();
                }
            }

            private boolean isProjectVariable(DataObject object) {
                return object instanceof ProjectDataObject;
            }
        };
        return projectListener;
    }

    private Table createAvailableColumnsTable(UiContainer parent, Presentation presentation) {
        AvailableColumnsTableModel availableColumnsTableModel = new AvailableColumnsTableModel(presentation);
        this.availableColumnsTable = new Table(parent, (TableModel)availableColumnsTableModel, ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.availableColumnsTable.setToolTipText(DesignerMsg.AVAILABLE_COLUMNS.getDetail());
        if (this.availableColumnsTable.getRowCount() > 0) {
            this.availableColumnsTable.setSelectionInterval(0, 0);
        } else {
            this.selectColumnAction.setEnabled(false);
        }
        this.availableColumnsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = PresentationPanelBuilder.this.availableColumnsTable.getSelectedRow();
                boolean allowAction = selectedIndex >= 0 && PresentationPanelBuilder.this.availableColumnsTable.getRowCount() > 0;
                PresentationPanelBuilder.this.selectColumnAction.setEnabled(allowAction);
            }
        });
        this.availableColumnsTable.setPreferredSize(Dimension.valueOf(200, 250));
        return this.availableColumnsTable;
    }

    private Panel createAvailableColumnsActions(UiContainer parent) {
        Panel panel = new Panel(parent);
        Box box = Box.createVerticalBox((UiContainer)panel);
        box.add(Box.createHorizontalStrut((UiContainer)box, (int)25));
        Button selectColumnButton = new Button((UiContainer)box, (BaseAction)this.selectColumnAction);
        selectColumnButton.setBorder(null);
        selectColumnButton.setBorderPainted(false);
        selectColumnButton.setContentAreaFilled(false);
        selectColumnButton.setPressedIcon(Image.create((Msg)DesignerMsg.MOVE_RIGHT_PRESSED));
        box.add((UiComponent)selectColumnButton);
        selectColumnButton.setOptions(-2);
        box.add(Box.createVerticalStrut((UiContainer)box, (int)25));
        Button unselectColumnButton = new Button((UiContainer)box, (BaseAction)this.unselectColumnAction);
        unselectColumnButton.setPressedIcon(Image.create((Msg)DesignerMsg.MOVE_LEFT_PRESSED));
        unselectColumnButton.setBorder(null);
        unselectColumnButton.setBorderPainted(false);
        unselectColumnButton.setContentAreaFilled(false);
        unselectColumnButton.setOptions(-2);
        box.add((UiComponent)unselectColumnButton);
        panel.add((UiComponent)box);
        return panel;
    }

    private Table createSelectedColumnsTable(UiContainer parent, Presentation presentation) {
        this.selectedColumnsTable = new Table(parent, (TableModel)new SelectedColumnsTableModel(presentation), ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.selectedColumnsTable.setToolTipText(DesignerMsg.SELECTED_COLUMNS);
        if (this.selectedColumnsTable.getRowCount() > 0) {
            this.selectedColumnsTable.setSelectionInterval(0, 0);
        } else {
            this.moveColumnDownAction.setEnabled(false);
            this.moveColumnUpAction.setEnabled(false);
            this.unselectColumnAction.setEnabled(false);
        }
        this.selectedColumnsTable.getColumn(1).setWidth(50);
        this.selectedColumnsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = PresentationPanelBuilder.this.selectedColumnsTable.getSelectedRow();
                PresentationPanelBuilder.this.enableSelectedUpDownActions(selectedIndex);
                PresentationPanelBuilder.this.enableAddToSortingAction();
            }
        });
        this.selectedColumnsTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                PresentationPanelBuilder.this.refreshPreviewPanel();
                PresentationPanelBuilder.this.setDirty();
            }
        });
        this.selectedColumnsTable.setPreferredSize(Dimension.valueOf(200, 250));
        return this.selectedColumnsTable;
    }

    private Panel createSelectedColumnsActions(UiContainer parent) {
        Panel panel = new Panel(parent);
        Box box = Box.createVerticalBox((UiContainer)panel);
        box.add(Box.createVerticalStrut((UiContainer)box, (int)10));
        Button upButton = new Button((UiContainer)box, (BaseAction)this.moveColumnUpAction);
        upButton.setPressedIcon(DesignerMsg.MOVE_UP_PRESSED);
        upButton.setBorder(null);
        upButton.setBorderPainted(false);
        upButton.setContentAreaFilled(false);
        upButton.setOptions(-2);
        box.add((UiComponent)upButton);
        box.add(Box.createVerticalStrut((UiContainer)box, (int)25));
        Button downButton = new Button((UiContainer)box, (BaseAction)this.moveColumnDownAction);
        downButton.setPressedIcon(DesignerMsg.MOVE_DOWN_PRESSED);
        downButton.setBorder(null);
        downButton.setBorderPainted(false);
        downButton.setContentAreaFilled(false);
        downButton.setOptions(-2);
        box.add((UiComponent)downButton);
        panel.add((UiComponent)box);
        Button toSortButton = new Button((UiContainer)panel, (BaseAction)this.sortingColumnAction);
        toSortButton.setPressedIcon(Image.create((Msg)DesignerMsg.MOVE_RIGHT_PRESSED));
        toSortButton.setBorder(null);
        toSortButton.setBorderPainted(false);
        toSortButton.setContentAreaFilled(false);
        toSortButton.setOptions(-2);
        panel.add((UiComponent)toSortButton);
        return panel;
    }

    private Table createSortingColumnsTable(Panel parent) {
        this.sortingTable = new Table((UiContainer)parent, (TableModel)new SortingColumnsTableModel(this.presentation), ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.sortingTable.setToolTipText(DesignerMsg.SELECTED_COLUMNS);
        this.sortingTable.getColumn(1).setCellEditor((TableCellEditor)new SortingCellEditor());
        if (this.sortingTable.getRowCount() > 0) {
            this.sortingTable.setSelectionInterval(0, 0);
        } else {
            this.moveColumnDownAction.setEnabled(false);
            this.moveColumnUpAction.setEnabled(false);
            this.unselectColumnAction.setEnabled(false);
        }
        this.sortingTable.getColumn(1).setWidth(50);
        this.sortingTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = PresentationPanelBuilder.this.sortingTable.getSelectedRow();
                PresentationPanelBuilder.this.enableSortingUpAndDownActions(selectedIndex);
            }
        });
        this.sortingTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                PresentationPanelBuilder.this.refreshPreviewPanel();
                PresentationPanelBuilder.this.setDirty();
            }
        });
        this.sortingTable.setPreferredSize(Dimension.valueOf(200, 250));
        return this.sortingTable;
    }

    private UiComponent createSortingColumnsActions(Panel parent) {
        Panel panel = new Panel((UiContainer)parent);
        Box box = Box.createVerticalBox((UiContainer)panel);
        box.add(Box.createVerticalStrut((UiContainer)box, (int)10));
        Button upButton = new Button((UiContainer)box, (BaseAction)this.moveOrderingColumnUpAction);
        upButton.setPressedIcon(DesignerMsg.MOVE_UP_PRESSED);
        upButton.setBorder(null);
        upButton.setBorderPainted(false);
        upButton.setContentAreaFilled(false);
        upButton.setOptions(-2);
        box.add((UiComponent)upButton);
        box.add(Box.createVerticalStrut((UiContainer)box, (int)25));
        Button downButton = new Button((UiContainer)box, (BaseAction)this.moveOrderingColumnDownAction);
        downButton.setPressedIcon(DesignerMsg.MOVE_DOWN_PRESSED);
        downButton.setBorder(null);
        downButton.setBorderPainted(false);
        downButton.setContentAreaFilled(false);
        downButton.setOptions(-2);
        box.add((UiComponent)downButton);
        box.add(Box.createVerticalStrut((UiContainer)box, (int)25));
        Button deleteSortedColumnButton = new Button((UiContainer)box, (BaseAction)this.deleteOrderingColumnAction);
        deleteSortedColumnButton.setBorder(null);
        deleteSortedColumnButton.setBorderPainted(false);
        deleteSortedColumnButton.setContentAreaFilled(false);
        deleteSortedColumnButton.setOptions(-2);
        box.add((UiComponent)deleteSortedColumnButton);
        panel.add((UiComponent)box);
        return panel;
    }

    private UiComponent createFormatTable(UiContainer container, final UiContainer rootContainer) {
        AvailableColumnsFormatModel model = new AvailableColumnsFormatModel(this.presentation);
        RowPanelBuilder rowPanelBuilder = new RowPanelBuilder(model, new FormatRowEditorFactory());
        this.formatTable = rowPanelBuilder.createRowsPanel(container);
        this.formatTable.addListener(new RowPanelListener(){

            @Override
            public void rowAdded(RowPanelEvent event) {
                PresentationPanelBuilder.this.setDirty();
                rootContainer.revalidate();
            }

            @Override
            public void rowRemoved(RowPanelEvent event) {
                PresentationPanelBuilder.this.setDirty();
                rootContainer.revalidate();
            }

            @Override
            public void rowUpdated(RowPanelEvent event) {
                PresentationPanelBuilder.this.setDirty();
            }
        });
        return this.formatTable;
    }

    private void setDirty() {
        this.presentationPanel.setDirty(true);
    }

    private Panel createHeaderPanel(UiContainer parent) {
        BorderPanel headerPanel = new BorderPanel(parent);
        String cols = "5dlu, pref, 5dlu, pref, fill:5dlu:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)headerPanel);
        CellConstraints cc = layout.createCellConstraints();
        Label presentationName = Label.create((UiContainer)headerPanel, (Msg)Msg.QUOTE(this.presentation.getId()));
        builder.add((UiComponent)Label.create((UiContainer)headerPanel, (Msg)DesignerMsg.VIEWS_PRESENTATION_NAME), cc.xy(2, 2));
        builder.add((UiComponent)presentationName, cc.xy(4, 2));
        return headerPanel;
    }

    private void createPresentationPreviewPanel(UiContainer parent) {
        this.presentationPreviewPanel = new PresentationPreviewPanel(parent, this.presentation);
        this.presentationPreviewPanel.setToolTipText(DesignerMsg.PRESENTATION_PREVIEW.getDetail());
    }

    private void createActions(UiContainer rootContainer) {
        this.moveColumnUpAction = new MoveSelectedColumnUpAction();
        this.moveColumnUpAction.setEnabled(false);
        this.moveColumnDownAction = new MoveSelectedColumnDownAction();
        this.selectColumnAction = new SelectColumnAction(rootContainer);
        this.unselectColumnAction = new UnselectColumnAction();
        this.sortingColumnAction = new AddToSortingAction();
        this.moveOrderingColumnUpAction = new MoveSortingColumnUpAction();
        this.moveOrderingColumnDownAction = new MoveSortingColumnDownAction();
        this.deleteOrderingColumnAction = new DeleteSortingColumnAction();
    }

    private void refreshPreviewPanel() {
        if (this.presentationPreviewPanel != null) {
            this.presentationPreviewPanel.drawTable();
        }
    }

    private void enableSelectedUpDownActions(int selectedIndex) {
        boolean allowAction = selectedIndex >= 0 && this.selectedColumnsTable.getRowCount() > 0;
        boolean enableDown = allowAction && selectedIndex < this.selectedColumnsTable.getRowCount() - 1;
        this.moveColumnDownAction.setEnabled(enableDown);
        boolean enableUp = allowAction && selectedIndex > 0;
        this.moveColumnUpAction.setEnabled(enableUp);
        this.unselectColumnAction.setEnabled(allowAction);
    }

    private void enableSortingUpAndDownActions(int selectedIndex) {
        boolean allowAction = selectedIndex >= 0 && this.sortingTable.getRowCount() > 0;
        boolean enableDown = allowAction && selectedIndex < this.sortingTable.getRowCount() - 1;
        this.moveOrderingColumnDownAction.setEnabled(enableDown);
        boolean enableUp = allowAction && selectedIndex > 0;
        this.moveOrderingColumnUpAction.setEnabled(enableUp);
        this.unselectColumnAction.setEnabled(allowAction);
        boolean allowRemove = this.sortingTable.getRowCount() > 0;
        this.deleteOrderingColumnAction.setEnabled(allowRemove);
    }

    private void enableAddToSortingAction() {
        int row = this.selectedColumnsTable.getSelectedRow();
        SelectedColumnsTableModel selectedColumnsTableModel = (SelectedColumnsTableModel)this.selectedColumnsTable.getModel();
        if (row >= 0 && row < selectedColumnsTableModel.getRowCount()) {
            Presentation.Column column = selectedColumnsTableModel.getRowItem(row);
            boolean allowSetForSorting = !((SortingColumnsTableModel)this.sortingTable.getModel()).contains(column);
            this.sortingColumnAction.setEnabled(allowSetForSorting);
        }
    }

    private class UnselectColumnAction
    extends BaseAction {
        static final long serialVersionUID = -2202351214434618976L;
        static final long serialCheck = 3774389353780645696L;

        public UnselectColumnAction() {
            super(DesignerMsg.VIEWS_MOVE_LEFT);
        }

        public void run() {
            int[] selectedRows;
            AbstractColumnsTableModel sourceTableModel = (AbstractColumnsTableModel)PresentationPanelBuilder.this.selectedColumnsTable.getModel();
            AbstractColumnsTableModel destinationTableModel = (AbstractColumnsTableModel)PresentationPanelBuilder.this.availableColumnsTable.getModel();
            AvailableColumnsFormatModel formatTableModel = (AvailableColumnsFormatModel)PresentationPanelBuilder.this.formatTable.getModel();
            List<Presentation.Column> removedColumns = CollectionFactory.createList();
            for (int selectedRow : selectedRows = PresentationPanelBuilder.this.selectedColumnsTable.getSelectedRows()) {
                Presentation.Column column = sourceTableModel.getRowItem(selectedRow);
                removedColumns.add(column);
                destinationTableModel.addColumn(column);
                formatTableModel.removeColumn(column);
                int lastRowIndex = PresentationPanelBuilder.this.availableColumnsTable.getRowCount() - 1;
                PresentationPanelBuilder.this.availableColumnsTable.setSelectionInterval(lastRowIndex, lastRowIndex);
                PresentationPanelBuilder.this.enableSelectedUpDownActions(lastRowIndex);
            }
            for (Presentation.Column column : removedColumns) {
                sourceTableModel.removeColumn(column);
            }
            PresentationPanelBuilder.this.selectedColumnsTable.setSelectionInterval(0, 0);
            int rowCount = PresentationPanelBuilder.this.selectedColumnsTable.getRowCount();
            if (rowCount == 0) {
                this.setEnabled(false);
            }
            if (!PresentationPanelBuilder.this.unselectColumnAction.isEnabled()) {
                PresentationPanelBuilder.this.unselectColumnAction.setEnabled(true);
                PresentationPanelBuilder.this.selectedColumnsTable.setSelectionInterval(0, 0);
            }
            PresentationPanelBuilder.this.availableColumnsTable.repaint();
            PresentationPanelBuilder.this.selectedColumnsTable.repaint();
            PresentationPanelBuilder.this.formatTable.getParent().revalidate();
            PresentationPanelBuilder.this.refreshPreviewPanel();
            PresentationPanelBuilder.this.setDirty();
        }
    }

    private class SortingCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBox editor;

        private SortingCellEditor() {
        }

        public Object getCellEditorValue() {
            return this.editor.getSelectedItem();
        }

        public UiComponent getTableCellEditor(Table component, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)component, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.editor = UiFactory.createComboBox((UiContainer)parent, Arrays.asList(DesignerMsg.ASCENDING.getString(), DesignerMsg.DESCENDING.getString()));
            return this.editor;
        }
    }

    private class SelectColumnAction
    extends BaseAction {
        private final UiContainer rootContainer;
        static final long serialVersionUID = 1212959996778860808L;
        static final long serialCheck = -7888126869205322149L;

        public SelectColumnAction(UiContainer rootContainer) {
            super(DesignerMsg.VIEWS_MOVE_RIGHT);
            this.rootContainer = rootContainer;
        }

        public void run() {
            AvailableColumnsTableModel model = (AvailableColumnsTableModel)PresentationPanelBuilder.this.availableColumnsTable.getModel();
            int[] selectedRows = PresentationPanelBuilder.this.availableColumnsTable.getSelectedRows();
            int firstSelection = selectedRows[0];
            Presentation.Column[] columns = new Presentation.Column[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                Presentation.Column column;
                columns[i] = column = model.getRowItem(selectedRows[i]);
                ((AvailableColumnsFormatModel)PresentationPanelBuilder.this.formatTable.getModel()).addColumn(column);
            }
            ((SelectedColumnsTableModel)PresentationPanelBuilder.this.selectedColumnsTable.getModel()).addColumns(columns);
            int lastRowIndex = PresentationPanelBuilder.this.selectedColumnsTable.getRowCount() - 1;
            PresentationPanelBuilder.this.selectedColumnsTable.setSelectionInterval(lastRowIndex, lastRowIndex);
            PresentationPanelBuilder.this.enableSelectedUpDownActions(lastRowIndex);
            PresentationPanelBuilder.this.availableColumnsTable.setSelectionInterval(0, 0);
            ((AvailableColumnsTableModel)PresentationPanelBuilder.this.availableColumnsTable.getModel()).reload();
            int rowCount = PresentationPanelBuilder.this.availableColumnsTable.getRowCount();
            if (firstSelection >= rowCount - 1) {
                PresentationPanelBuilder.this.availableColumnsTable.setSelectionInterval(rowCount - 1, rowCount - 1);
            } else {
                PresentationPanelBuilder.this.availableColumnsTable.setSelectionInterval(firstSelection, firstSelection);
            }
            if (rowCount == 0) {
                this.setEnabled(false);
            }
            if (!PresentationPanelBuilder.this.unselectColumnAction.isEnabled()) {
                PresentationPanelBuilder.this.unselectColumnAction.setEnabled(true);
                PresentationPanelBuilder.this.selectedColumnsTable.setSelectionInterval(0, 0);
            }
            PresentationPanelBuilder.this.availableColumnsTable.repaint();
            PresentationPanelBuilder.this.selectedColumnsTable.repaint();
            PresentationPanelBuilder.this.formatTable.getParent().revalidate();
            PresentationPanelBuilder.this.refreshPreviewPanel();
            PresentationPanelBuilder.this.setDirty();
            this.rootContainer.revalidate();
        }
    }

    private class MoveSortingColumnUpAction
    extends BaseAction {
        public MoveSortingColumnUpAction() {
            super(DesignerMsg.VIEWS_MOVE_UP);
        }

        public void run() {
            int row = PresentationPanelBuilder.this.sortingTable.getSelectedRow();
            if (row > 0) {
                ((SortingColumnsTableModel)PresentationPanelBuilder.this.sortingTable.getModel()).moveColumnUp(row);
                PresentationPanelBuilder.this.sortingTable.repaint();
                PresentationPanelBuilder.this.sortingTable.setSelectionInterval(row - 1, row - 1);
                PresentationPanelBuilder.this.refreshPreviewPanel();
                PresentationPanelBuilder.this.setDirty();
            }
        }
    }

    private class MoveSortingColumnDownAction
    extends BaseAction {
        public MoveSortingColumnDownAction() {
            super(DesignerMsg.VIEWS_MOVE_DOWN);
        }

        public void run() {
            int row = PresentationPanelBuilder.this.sortingTable.getSelectedRow();
            if (row != -1 && row < PresentationPanelBuilder.this.sortingTable.getRowCount() - 1) {
                ((SortingColumnsTableModel)PresentationPanelBuilder.this.sortingTable.getModel()).moveColumnDown(row);
                PresentationPanelBuilder.this.sortingTable.repaint();
                PresentationPanelBuilder.this.sortingTable.setSelectionInterval(row + 1, row + 1);
                PresentationPanelBuilder.this.setDirty();
            }
        }
    }

    private class MoveSelectedColumnUpAction
    extends BaseAction {
        static final long serialVersionUID = -7879631644642423310L;
        static final long serialCheck = -6622196267569798532L;

        public MoveSelectedColumnUpAction() {
            super(DesignerMsg.VIEWS_MOVE_UP);
        }

        public void run() {
            int row = PresentationPanelBuilder.this.selectedColumnsTable.getSelectedRow();
            ((SelectedColumnsTableModel)PresentationPanelBuilder.this.selectedColumnsTable.getModel()).moveColumnUp(row);
            PresentationPanelBuilder.this.selectedColumnsTable.repaint();
            PresentationPanelBuilder.this.selectedColumnsTable.setSelectionInterval(--row, row);
            PresentationPanelBuilder.this.enableSelectedUpDownActions(row);
            PresentationPanelBuilder.this.refreshPreviewPanel();
            PresentationPanelBuilder.this.setDirty();
        }
    }

    private class MoveSelectedColumnDownAction
    extends BaseAction {
        static final long serialVersionUID = 722455051013293030L;
        static final long serialCheck = 2343135052148310336L;

        public MoveSelectedColumnDownAction() {
            super(DesignerMsg.VIEWS_MOVE_DOWN);
        }

        public void run() {
            int row = PresentationPanelBuilder.this.selectedColumnsTable.getSelectedRow();
            ((SelectedColumnsTableModel)PresentationPanelBuilder.this.selectedColumnsTable.getModel()).moveColumnDown(row);
            PresentationPanelBuilder.this.selectedColumnsTable.repaint();
            PresentationPanelBuilder.this.selectedColumnsTable.setSelectionInterval(++row, row);
            PresentationPanelBuilder.this.enableSelectedUpDownActions(row);
            PresentationPanelBuilder.this.refreshPreviewPanel();
            PresentationPanelBuilder.this.setDirty();
        }
    }

    private class DeleteSortingColumnAction
    extends BaseAction {
        public DeleteSortingColumnAction() {
            super(DesignerMsg.DELETE);
        }

        public void run() {
            TableCellEditor cellEditor = PresentationPanelBuilder.this.sortingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            AbstractColumnsTableModel sourceTableModel = (AbstractColumnsTableModel)PresentationPanelBuilder.this.sortingTable.getModel();
            int[] selectedRows = PresentationPanelBuilder.this.sortingTable.getSelectedRows();
            List<Presentation.Column> columns = CollectionFactory.createList();
            for (int selectedRow : selectedRows) {
                Presentation.Column column = sourceTableModel.getRowItem(selectedRow);
                columns.add(column);
            }
            for (Presentation.Column column : columns) {
                sourceTableModel.removeColumn(column);
            }
            PresentationPanelBuilder.this.sortingTable.repaint();
            PresentationPanelBuilder.this.refreshPreviewPanel();
            PresentationPanelBuilder.this.enableAddToSortingAction();
            PresentationPanelBuilder.this.setDirty();
        }
    }

    private class AddToSortingAction
    extends BaseAction {
        public AddToSortingAction() {
            super(DesignerMsg.VIEW_SORTING);
        }

        public void run() {
            AbstractColumnsTableModel model = (AbstractColumnsTableModel)PresentationPanelBuilder.this.selectedColumnsTable.getModel();
            AbstractColumnsTableModel sortingTableModel = (AbstractColumnsTableModel)PresentationPanelBuilder.this.sortingTable.getModel();
            for (int selectedRow : PresentationPanelBuilder.this.selectedColumnsTable.getSelectedRows()) {
                Presentation.Column column = model.getRowItem(selectedRow);
                sortingTableModel.addColumn(column);
            }
            PresentationPanelBuilder.this.selectedColumnsTable.repaint();
            PresentationPanelBuilder.this.sortingTable.repaint();
            PresentationPanelBuilder.this.refreshPreviewPanel();
            PresentationPanelBuilder.this.setDirty();
        }
    }
}

