/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.action.ClosePresentationAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.designer.view.gui.PresentationPanelBuilder;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.presentation.presentations.PresentationAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

@Editor(objectClass=Presentation.class)
public class PresentationPanel
extends AbstractEditor<Presentation> {
    public PresentationPanel(UiContainer parent, PresentationAdapter presentation) {
        super(parent, presentation, Presentation.class);
        this.setName(presentation.getId());
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.VIEW_PRESENTATION;
    }

    @Override
    public Image getIcon() {
        if (((Presentation)this.getProjectObject()).isReadOnly()) {
            return IconFactory.createReadOnly(Image.create((Msg)DesignerMsg.VIEWS_PRESENTATION));
        }
        return Image.create((Msg)DesignerMsg.VIEWS_PRESENTATION);
    }

    public String getId() {
        return ((Presentation)this.getProjectObject()).getId();
    }

    @Override
    public Object getInput() {
        return this.getProjectObject();
    }

    public String getPresenationName() {
        return ((Presentation)this.getProjectObject()).getId();
    }

    @Override
    public String getTitle() {
        return this.getPresenationName();
    }

    @Override
    public boolean close() {
        return new ClosePresentationAction((Presentation)this.getProjectObject()).doIt();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Panel presentationPanel = new PresentationPanelBuilder((Presentation)this.getProjectObject(), this).buildPresentationPanel(parent);
        parent.setLayout((Layout)new BorderLayout());
        parent.add((UiComponent)presentationPanel, (Object)"Center");
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }
}

