/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;

class SizePanel
extends Panel {
    private Label lengthLabel;
    private NumericField<Integer> lengthSpinner;
    private Label scaleLabel;
    private NumericField<Integer> scaleSpinner;
    private CatalogType type;

    SizePanel(UiContainer parent) {
        super(parent);
        this.init();
    }

    public void setTypeDescription(CatalogType type) {
        this.type = type;
        boolean isSupportSize = false;
        boolean isSupportScale = ProjectVariableImpl.isSupportScale((CatalogType)type);
        this.lengthLabel.setVisible(isSupportSize);
        this.lengthSpinner.setVisible(isSupportSize);
        this.scaleLabel.setVisible(isSupportScale);
        this.scaleSpinner.setVisible(isSupportScale);
        if (isSupportSize) {
            int length = type.getLength() > -1 ? type.getLength() : ProjectVariableImpl.getDefaultLength((CatalogType)type);
            this.setLength(length);
        }
        if (isSupportScale) {
            int scale = type.getScale() > -1 ? type.getScale() : ProjectVariableImpl.getDefaultScale((CatalogType)type);
            this.setScale(scale);
        }
    }

    public CatalogType getTypeDescription() {
        return CatalogType.Default.get((TypeRef)TypeFactory.forKind(this.type.getKind(), this.getLength(), this.getScale()).primitiveEquivalent(false));
    }

    private static NumericField<Integer> createSpinner(UiContainer parent, int value, int min, int max, int step) {
        NumericField spinner = NumericField.createIntegerNumericField((UiContainer)parent);
        spinner.setValue((Number)value);
        spinner.setRange((Number)min, (Number)max);
        spinner.setStepSize((Number)step);
        spinner.setAllowsInvalid(false);
        spinner.setOverwriteMode(true);
        return spinner;
    }

    private int getLength() {
        int kind = this.type.getKind();
        return this.lengthSpinner.isVisible() ? (Integer)this.lengthSpinner.getValue() : (kind == 2 ? 32 : -1);
    }

    private int getScale() {
        return this.scaleSpinner.isVisible() ? (Integer)this.scaleSpinner.getValue() : -1;
    }

    private void setLength(int length) {
        this.lengthSpinner.setValue((Number)length);
    }

    private void setScale(int length) {
        this.scaleSpinner.setValue((Number)length);
    }

    private void init() {
        String colSpecs = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        String rowSpecs = "pref";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        this.lengthLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TYPES_LENGTH);
        this.lengthSpinner = SizePanel.createSpinner((UiContainer)this, 1, 1, 255, 1);
        this.scaleLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TYPES_SCALE);
        this.scaleSpinner = SizePanel.createSpinner((UiContainer)this, 1, 0, 255, 1);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.lengthLabel, cc.xy(1, 1));
        builder.add(this.lengthSpinner, cc.xy(3, 1));
        builder.add((UiComponent)this.scaleLabel, cc.xy(5, 1));
        builder.add(this.scaleSpinner, cc.xy(7, 1));
        this.setTypeDescription(ProjectObjectEditorPanel.DEFAULT_TYPE);
    }
}

