/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectObjectEditorDialog;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemFactory;
import oracle.bpm.designer.variables.DataPanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

class ProjectBusinessIndicatorEditorPanel
extends ProjectObjectEditorPanel<ProjectDataObject> {
    private ComboBox<BusinessVariableType> businessVariableTypeCombo;
    private BusinessVariableType contextType;
    private DataPanel dataPanel;
    private IdentifierTextField idTextField;
    private CheckBox initializeCheckBox;
    private boolean isEdition;
    private String oldId;
    private CILTypeComboBox typeCombo;
    private static final int MAX_LENGTH = 60;

    private ProjectBusinessIndicatorEditorPanel(UiContainer parent, ProjectDataObject dataObject, BusinessVariableType type) {
        super(parent, dataObject);
        NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
        String id = dataObject.getId();
        this.isEdition = nodeContainer.findDataObject(id) != null;
        this.oldId = id;
        this.contextType = type;
        this.init();
    }

    public static ProjectBusinessIndicatorEditorPanel create(UiWindow parent, ProjectDataObject dataObject, BusinessVariableType type) {
        return new ProjectBusinessIndicatorEditorPanel((UiContainer)parent, dataObject, type);
    }

    public static BusinessIndicatorDialog createDialog(UiWindow parent, Msg title, ProjectDataObject dataObject, BusinessVariableType type) {
        BusinessIndicatorDialog dialog = new BusinessIndicatorDialog(parent, title, dataObject, type);
        dialog.setSize(500, 300);
        return dialog;
    }

    @Override
    public ProjectDataObject editorToObject() throws ProjectException {
        ProjectDataObject dataObject = (ProjectDataObject)this.getProjectObject();
        CatalogType type = this.getTypeDescription();
        BusinessVariableData data = this.getBusinessVariableData();
        dataObject.setId(this.idTextField.getText().trim());
        dataObject.setInitialize(this.initializeCheckBox.isSelected());
        dataObject.setTypeDescription(type);
        BusinessVariableType businessType = (BusinessVariableType)this.businessVariableTypeCombo.getSelectedItem();
        dataObject.setBusinessVariableType(businessType);
        dataObject.setBusinessVariableData(data);
        return dataObject;
    }

    @Override
    public void validatePanel() throws ProjectException {
        NodeContainer nodeContainer;
        ProjectDataObject dataObject = (ProjectDataObject)this.getProjectObject();
        String id = this.idTextField.getText().trim();
        if (Str.isEmpty(id)) {
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.DECLARATION_NAME_IS_NULL(DesignerMsg.BUSINESS_INDICATOR.getString()));
        }
        if (!(this.isEdition && id.equals(this.oldId) || (nodeContainer = (NodeContainer)dataObject.getParentObject()).findDataObject(id) == null)) {
            throw new ProjectException((ProjectObject)dataObject, ProjectMsg.BUSINESS_INDICATOR_ALREADY_EXISTS((String)id));
        }
        if (this.isValidDataPanel()) {
            this.dataPanel.validatePanel((DataObject)dataObject, id);
        }
    }

    @Override
    public void objectToEditor(ProjectDataObject dataObject) {
        this.idTextField.setText(dataObject.getId());
        CatalogType type = dataObject.getType();
        this.typeCombo.setSelectedItem(type);
        this.initializeCheckBox.setSelected(dataObject.isInitialize());
        BusinessVariableType businessType = dataObject.getBusinessVariableType();
        this.businessVariableTypeCombo.setSelectedItem((Object)businessType);
        this.updateInitializeCheckBox(businessType);
        if (this.dataPanel != null) {
            this.dataPanel.setBusinessVariableData(dataObject.getBusinessVariableData());
            this.updateDataPanelState(type);
        }
    }

    public void configureForGenericBusinessIndicator() {
    }

    void configureForMeasurementMarkBI() {
    }

    void configureForCountersBI() {
    }

    private void updateInitializeCheckBox(BusinessVariableType businessType) {
        boolean isCounter = businessType.isCounter();
        if (isCounter) {
            this.initializeCheckBox.setSelected(true);
        }
        this.initializeCheckBox.setEnabled(!isCounter);
    }

    private BusinessVariableData getBusinessVariableData() {
        return this.isValidDataPanel() ? this.dataPanel.getBusinessVariableData() : null;
    }

    private boolean isValidDataPanel() {
        return this.dataPanel != null && this.dataPanel.isEnabled();
    }

    private void init() {
        this.idTextField = new IdentifierTextField((UiContainer)this, 30, true);
        this.idTextField.setTextLimit(30);
        List<BusinessVariableType> businessVariableTypeList = this.createBusinessVariableTypeList();
        this.businessVariableTypeCombo = UiFactory.createMutableComboBox((UiContainer)this, businessVariableTypeList);
        this.businessVariableTypeCombo.setSelectedItem((Object)ProjectVariableImpl.getDefaultType((CatalogType)DEFAULT_TYPE));
        this.businessVariableTypeCombo.setEnabled(businessVariableTypeList.size() > 1);
        Panel typeDescriptionPanel = this.buildTypeDescriptionPanel();
        this.initializeCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.AUTO_INITIALIZE);
        this.businessVariableTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ProjectBusinessIndicatorEditorPanel.this.updateTypeCombo();
                ProjectBusinessIndicatorEditorPanel.this.updateInitializeCheckBox((BusinessVariableType)ProjectBusinessIndicatorEditorPanel.this.businessVariableTypeCombo.getSelectedItem());
                if (e.isStateSelected()) {
                    CatalogType type = ((TypeItem)ProjectBusinessIndicatorEditorPanel.this.typeCombo.getSelectedItem()).getRef();
                    ProjectBusinessIndicatorEditorPanel.this.updateDataPanelState(type);
                }
            }
        });
        FormLayout layout = this.createStandardLayout();
        this.setLayout((Layout)layout);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)ProjectDrawMsg.NAME), (UiComponent)this.idTextField);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.BUSINESS_INDICATOR), (UiComponent)this.businessVariableTypeCombo);
        this.appendRow(layout, (UiComponent)Label.create((UiContainer)this, (Msg)CoreMsg.TYPE), (UiComponent)typeDescriptionPanel);
        if (this.contextType.isDimension()) {
            this.dataPanel = new DataPanel((UiContainer)this);
            this.appendExpandedRow(layout, (UiComponent)this.dataPanel);
            this.dataPanel.setEnabled(this.contextType.isDimension());
        }
        this.appendRow(layout, (UiComponent)this.initializeCheckBox);
        if (!this.isEdition) {
            this.idTextField.requestFocus();
            this.idTextField.selectAll();
        } else {
            this.typeCombo.requestFocus();
        }
    }

    private void updateTypeCombo() {
        TypeItem typeItem = (TypeItem)this.typeCombo.getSelectedItem();
        this.typeCombo.removeAllItems();
        Iterable<TypeItem> validTypes = ((BusinessVariableType)this.businessVariableTypeCombo.getSelectedItem()).isDimension() ? TypeItemFactory.createProjectVariableValidTypes() : (((BusinessVariableType)this.businessVariableTypeCombo.getSelectedItem()).isCounter() ? TypeItemFactory.createCounterProjectVariableValidTypes() : TypeItemFactory.createBusinessIndicatorProjectVariableValidTypes());
        for (TypeItem type : validTypes) {
            this.typeCombo.addItem(type);
        }
        boolean found = false;
        for (TypeItem validType : validTypes) {
            if (!validType.getId().equals((Object)typeItem.getId())) continue;
            this.typeCombo.setSelectedItem(typeItem.getRef());
            found = true;
            break;
        }
        if (!found) {
            this.typeCombo.setSelectedIndex(0);
        }
        this.typeCombo.setEnabled(this.typeCombo.getItemCount() > 1);
        this.clearDataPanel();
    }

    private void clearDataPanel() {
        if (this.dataPanel != null) {
            this.dataPanel.clear();
        }
    }

    private void updateDataPanelState(CatalogType type) {
        if (this.dataPanel != null) {
            BusinessVariableType businessVariableType = (BusinessVariableType)this.businessVariableTypeCombo.getSelectedItem();
            this.dataPanel.setInt(type.isInt());
            this.dataPanel.setEnabled(type.isNumber() && businessVariableType.isDimension());
        }
    }

    private List<BusinessVariableType> createBusinessVariableTypeList() {
        ArrayList<BusinessVariableType> result = new ArrayList<BusinessVariableType>();
        if (this.contextType.isMeasure()) {
            result.add(BusinessVariableType.MEASURE);
        } else if (this.contextType.isCounter()) {
            result.add(BusinessVariableType.COUNTER);
        } else {
            result.add(BusinessVariableType.DIMENSION);
            result.add(BusinessVariableType.MEASURE);
            result.add(BusinessVariableType.COUNTER);
        }
        return result;
    }

    private Panel buildTypeDescriptionPanel() {
        Panel typePanel = new Panel((UiContainer)this);
        FormLayout layout = new FormLayout("pref, 5dlu, pref", "pref");
        typePanel.setLayout((Layout)layout);
        this.typeCombo = new CILTypeComboBox((UiContainer)typePanel){

            @Override
            protected void addTypes() {
                Iterable<TypeItem> validTypes = ProjectBusinessIndicatorEditorPanel.this.contextType.isDimension() ? TypeItemFactory.createProjectVariableValidTypes() : (ProjectBusinessIndicatorEditorPanel.this.contextType.isCounter() ? TypeItemFactory.createCounterProjectVariableValidTypes() : TypeItemFactory.createBusinessIndicatorProjectVariableValidTypes());
                for (TypeItem type : validTypes) {
                    this.addType(type);
                }
            }
        };
        if (this.contextType.isDimension()) {
            this.typeCombo.setSelectedItem(DEFAULT_TYPE);
        } else {
            this.typeCombo.setSelectedIndex(0);
        }
        this.typeCombo.setEnabled(this.typeCombo.getItemCount() > 1);
        this.typeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    TypeItem item = (TypeItem)e.getItem();
                    ProjectBusinessIndicatorEditorPanel.this.clearDataPanel();
                    ProjectBusinessIndicatorEditorPanel.this.updateDataPanelState(item.getRef());
                }
            }
        });
        CellConstraints cc = layout.createCellConstraints();
        typePanel.add((UiComponent)this.typeCombo, (Object)cc.xy(1, 1));
        return typePanel;
    }

    private CatalogType getTypeDescription() {
        return ((TypeItem)this.typeCombo.getSelectedItem()).getRef();
    }

    private static class BusinessIndicatorDialog
    extends ProjectObjectEditorDialog<ProjectDataObject> {
        private boolean isEdition;
        private BusinessVariableType type;

        public BusinessIndicatorDialog(UiWindow parent, Msg title, ProjectDataObject dataObject, BusinessVariableType type) {
            super(parent, title);
            this.type = type;
            NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
            this.isEdition = nodeContainer.findDataObject(dataObject.getId()) != null;
            this.init(dataObject);
        }

        @Override
        public ProjectObjectEditorPanel<ProjectDataObject> buildEditor(UiContainer parent, ProjectDataObject dataObject) {
            return new ProjectBusinessIndicatorEditorPanel(parent, dataObject, this.type);
        }

        public String getHelpId() {
            return this.getHelpIdWithMsg();
        }

        @Override
        public void save(ProjectDataObject dataObject) throws ProjectException {
            NodeContainer nodeContainer = (NodeContainer)dataObject.getParentObject();
            if (!this.isEdition) {
                nodeContainer.addDataObject((DataObject)dataObject);
            }
            AbstractStudioWorkbench.storeProjectObjectIfNecessary((ProjectObject)dataObject.getProject().getProjectModel());
        }
    }
}

