/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;

class DataPanel
extends BaseTablePanel {
    private BaseAction moveDownAction;
    private BaseAction moveUpAction;

    DataPanel(UiContainer parent) {
        super(parent, null, LibMsg.RANGE, (TableModel)new DataModel(), BaseTablePanel.Style.TOOLBAR_TOP);
        this.init();
    }

    public void setInt(boolean isInt) {
        this.getModel().setInt(isInt);
    }

    public void validatePanel(DataObject dataObject, String id) throws ProjectException {
        DataModel model = this.getModel();
        List ranges = model.getData();
        if (ranges.isEmpty()) {
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.NO_RANGE_DEFINED);
        }
        for (BusinessVariableData.Range range : ranges) {
            if (Str.isEmpty(range.getName())) {
                throw new ProjectException((ProjectObject)dataObject, ProjectCompileMsg.RANGE_NAME_IS_EMPTY);
            }
            if (model.isValidName(range)) continue;
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.OBJECT_ALREADY_EXISTS(DesignerMsg.RANGE, range.getName()));
        }
        for (BusinessVariableData.Range range : ranges) {
            if (model.isValidRange(range)) continue;
            throw new ProjectException((ProjectObject)dataObject, DesignerMsg.BUSINESS_VARIABLE_DATA_ERROR(id));
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateArrows(enabled ? this.getTable().getSelectedRows() : new int[]{});
    }

    protected BaseAction[] getUserActions() {
        final Table table = this.getTable();
        final DataModel model = this.getModel();
        this.moveUpAction = new BaseAction(UIMsg.MOVE_UP){

            public void run() {
                DataPanel.this.stopCellEditor();
                int row = table.getSelectedRow();
                model.moveRowUp(row);
                table.setSelectionInterval(row - 1, row - 1);
            }
        };
        this.moveUpAction.setEnabled(false);
        this.moveDownAction = new BaseAction(UIMsg.MOVE_DOWN){

            public void run() {
                DataPanel.this.stopCellEditor();
                int row = table.getSelectedRow();
                model.moveRowDown(row);
                table.setSelectionInterval(row + 1, row + 1);
            }
        };
        this.moveDownAction.setEnabled(false);
        return new BaseAction[]{this.moveUpAction, this.moveDownAction};
    }

    protected void selectionChanged(int[] selectedRows) {
        super.selectionChanged(selectedRows);
        this.updateArrows(selectedRows);
    }

    protected void addAction() {
        this.stopCellEditor();
        DataModel model = this.getModel();
        model.addRow();
        this.updateArrows(this.getTable().getSelectedRows());
    }

    protected DataModel getModel() {
        return (DataModel)super.getModel();
    }

    BusinessVariableData getBusinessVariableData() {
        this.stopCellEditor();
        DataModel model = this.getModel();
        return model.getBusinessVariableData();
    }

    void setBusinessVariableData(BusinessVariableData data) {
        DataModel model = this.getModel();
        model.setBusinessVariableData(data);
    }

    void clear() {
        this.stopCellEditor();
        this.getModel().removeAllElements();
    }

    private void updateArrows(int[] selectedRows) {
        boolean isSingleSelection = selectedRows.length == 1;
        int row = isSingleSelection ? selectedRows[0] : -1;
        this.moveUpAction.setEnabled(isSingleSelection && row > 0);
        this.moveDownAction.setEnabled(isSingleSelection && row < this.getModel().getRowCount() - 1);
    }

    private void init() {
        Table table = this.getTable();
        TableColorProvider.Default<Object> nameColorProvider = new TableColorProvider.Default<Object>(){

            public Color getForeground(Object element) {
                BusinessVariableData.Range range;
                DataModel model = DataPanel.this.getModel();
                return model.isValidName(range = (BusinessVariableData.Range)model.getRow(this.getRow())) ? null : Color.RED;
            }
        };
        TableColorProvider.Default<Object> rangeColorProvider = new TableColorProvider.Default<Object>(){

            public Color getForeground(Object element) {
                BusinessVariableData.Range range;
                DataModel model = DataPanel.this.getModel();
                return model.isValidRange(range = (BusinessVariableData.Range)model.getRow(this.getRow())) ? null : Color.RED;
            }
        };
        table.getColumn(0).setColorProvider((ColorProvider)nameColorProvider);
        table.getColumn(1).setColorProvider((ColorProvider)rangeColorProvider);
        table.getColumn(2).setColorProvider((ColorProvider)rangeColorProvider);
    }

    private static class DataModel
    extends ProviderTableModel<BusinessVariableData.Range> {
        private boolean isInt;
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_START = 1;
        private static final int COLUMN_FINISH = 2;

        public DataModel() {
            super(MsgList.create(ProjectDrawMsg.NAME, CoreMsg.START, UIMsg.FINISH));
        }

        public void addRow() {
            String name = this.getDefaultName();
            BigDecimal start = BigDecimal.valueOf(this.isInt ? 1.0 : 1.0);
            BigDecimal finish = BigDecimal.valueOf(this.isInt ? 100.0 : 100.0);
            if (this.getRowCount() > 0) {
                BusinessVariableData.Range range = (BusinessVariableData.Range)this.getRow(this.getRowCount() - 1);
                BigDecimal previousStart = range.getStart();
                BigDecimal previousFinish = range.getFinish();
                BigDecimal offset = previousFinish.subtract(previousStart);
                start = previousFinish.add(BigDecimal.valueOf(1L));
                finish = start.add(offset);
            }
            this.insertRow(BusinessVariableData.Range.create(name, start, finish));
        }

        public Class getColumnClass(int column) {
            Class result = column == 0 ? String.class : (this.isInt ? Integer.class : BigDecimal.class);
            return result;
        }

        public Object getValueAt(int row, int column) {
            BusinessVariableData.Range range = (BusinessVariableData.Range)this.getRow(row);
            switch (column) {
                case 0: {
                    return range.getName();
                }
                case 1: {
                    return this.isInt ? Integer.valueOf(range.getStart().intValue()) : range.getStart();
                }
                case 2: {
                    return this.isInt ? Integer.valueOf(range.getFinish().intValue()) : range.getFinish();
                }
            }
            return "";
        }

        public void setInt(boolean isInt) {
            this.isInt = isInt;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void setValueAt(Object value, int row, int column) {
            BusinessVariableData.Range range = (BusinessVariableData.Range)this.getRow(row);
            switch (column) {
                case 0: {
                    range.setName(value.toString());
                    return;
                }
                case 1: {
                    range.setStart(this.isInt ? BigDecimal.valueOf(((Integer)value).intValue()) : (BigDecimal)value);
                    return;
                }
                case 2: {
                    range.setFinish(this.isInt ? BigDecimal.valueOf(((Integer)value).intValue()) : (BigDecimal)value);
                }
            }
            this.fireTableDataChanged();
        }

        boolean isValidName(BusinessVariableData.Range theRange) {
            List ranges = this.getData();
            HashSet<String> names = new HashSet<String>();
            for (BusinessVariableData.Range range : ranges) {
                if (range == theRange) continue;
                names.add(range.getName());
            }
            return !names.contains(theRange.getName());
        }

        boolean isValidRange(BusinessVariableData.Range theRange) {
            List ranges = this.getData();
            if (Str.isEmpty(theRange.getName())) {
                return false;
            }
            if (theRange.getStart().compareTo(theRange.getFinish()) == 0) {
                return false;
            }
            if (theRange.getFinish().compareTo(theRange.getStart()) == -1) {
                return false;
            }
            for (BusinessVariableData.Range range : ranges) {
                if (range == theRange) continue;
                BigDecimal start1 = range.getStart();
                BigDecimal finish1 = range.getFinish();
                BigDecimal start = theRange.getStart();
                BigDecimal finish = theRange.getFinish();
                if (start.compareTo(start1) == 0 || finish.compareTo(finish1) == 0) {
                    return false;
                }
                if (start.compareTo(start1) == 1 && start.compareTo(finish1) == -1) {
                    return false;
                }
                if (finish.compareTo(start1) == 1 && finish.compareTo(finish1) == -1) {
                    return false;
                }
                if (start.compareTo(start1) != 1 || finish.compareTo(finish1) != -1) continue;
                return false;
            }
            return true;
        }

        BusinessVariableData getBusinessVariableData() {
            BusinessVariableData data = new BusinessVariableData();
            for (int i = 0; i < this.getRowCount(); ++i) {
                data.addRange((BusinessVariableData.Range)this.getRow(i));
            }
            return data;
        }

        void insertRow(BusinessVariableData.Range range) {
            this.addRow(range);
        }

        void setBusinessVariableData(BusinessVariableData data) {
            BusinessVariableData.Range[] ranges;
            this.removeAllElements();
            if (data == null) {
                return;
            }
            for (BusinessVariableData.Range range : ranges = data.getRange()) {
                this.insertRow(range);
            }
        }

        private String getDefaultName() {
            String name;
            int i;
            HashSet<String> set = new HashSet<String>();
            for (i = 0; i < this.getRowCount(); ++i) {
                name = (String)this.getValueAt(i, 0);
                set.add(name.toLowerCase());
            }
            i = 0;
            name = ProjectDrawMsg.NAME.getString();
            String defaultName = name + i;
            while (set.contains(defaultName.toLowerCase())) {
                defaultName = name + ++i;
            }
            return defaultName;
        }
    }
}

