/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.variables;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.action.NewBusinessIndicatorAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.DataObjectRenderer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;

public class BusinessIndicatorsPanel
extends Panel {
    private BusinessIndicatorsTableModel businessIndicatorsTableModel;
    private Project project;
    private ProjectListener<ProjectDataObject> projectDataObjectListener;
    private static final int NAME_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;

    public BusinessIndicatorsPanel(UiContainer parent, Project project) {
        super(parent, null);
        this.project = project;
        this.buildUi();
    }

    public ProjectListener getProjectDataObjectListener() {
        if (this.projectDataObjectListener == null) {
            this.projectDataObjectListener = new ProjectListenerAdapter<ProjectDataObject>(ProjectDataObject.class){

                public void postObjectAdded(ProjectDataObject object, ProjectObject parent) {
                    BusinessIndicatorsPanel.this.getTableModel().addRow((Object)object);
                }

                public void postObjectRemoved(ProjectDataObject object, ProjectObject parent) {
                    BusinessIndicatorsPanel.this.getTableModel().removeRow(BusinessIndicatorsPanel.this.getTableModel().getRowIndex((Object)object));
                }
            };
        }
        return this.projectDataObjectListener;
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout());
        this.businessIndicatorsTableModel = new BusinessIndicatorsTableModel(this.project.getBusinessIndicators());
        BusinessIndicatorsTablePanel businessIndicatorsTablePanel = new BusinessIndicatorsTablePanel((UiContainer)this, (TableModel)this.businessIndicatorsTableModel);
        this.add((UiComponent)businessIndicatorsTablePanel, "Center");
    }

    private ProviderTableModel getTableModel() {
        return this.businessIndicatorsTableModel;
    }

    private class BusinessIndicatorsTablePanel
    extends BaseTablePanel {
        public BusinessIndicatorsTablePanel(UiContainer parent, TableModel tableModel) {
            super(parent, ProjectMsg.BUSINESS_INDICATORS, null, tableModel);
            this.getTable().getColumn(0).setLabelProvider((LabelProvider)new LabelProvider<DataObject>(){
                private ProjectObjectRenderer<DataObject> dataObjectRenderer = new DataObjectRenderer();

                public Image getIcon(DataObject element) {
                    return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
                }

                public String getText(DataObject element) {
                    return element.getDefaultLabel();
                }
            });
        }

        protected void addAction() {
            NewBusinessIndicatorAction newBusinessIndicatorAction = NewBusinessIndicatorAction.create();
            newBusinessIndicatorAction.runWithSelection(BusinessIndicatorsPanel.this.project.getProjectModel());
            ProjectDataObject newDataObject = (ProjectDataObject)newBusinessIndicatorAction.getDataObject();
            if (newDataObject != null) {
                BusinessIndicatorsPanel.this.businessIndicatorsTableModel.addRow(newDataObject);
            }
        }

        protected void deleteAction() {
            int[] selectedRows = this.getTable().getSelectedRows();
            try {
                for (int selectedRow : selectedRows) {
                    ProjectDataObject projectDataObject = (ProjectDataObject)BusinessIndicatorsPanel.this.businessIndicatorsTableModel.getRow(selectedRow);
                    projectDataObject.delete();
                }
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
            super.deleteAction();
        }
    }

    private static class BusinessIndicatorsTableModel
    extends ProviderTableModel<ProjectDataObject> {
        public BusinessIndicatorsTableModel(Iterable<ProjectDataObject> businessIndicators) {
            super(MsgList.create(DesignerMsg.NAME, DesignerMsg.TYPE));
            this.addRows(businessIndicators);
        }

        public Object getValueAt(int row, int column) {
            ProjectDataObject businessIndicator = (ProjectDataObject)this.getRow(row);
            return column == 0 ? businessIndicator : businessIndicator.getBusinessVariableType().getString();
        }
    }
}

