/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.validator.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.AbstractProjectObjectValidator;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrganizationalUnitExistenceValidator
extends AbstractProjectObjectValidator<OrganizationalUnit> {
    private OrganizationalChart organizationalChart;
    private OrganizationalUnit parentOu;

    public OrganizationalUnitExistenceValidator(@NotNull OrganizationalChart organizationalChart, @Nullable OrganizationalUnit parentOu) {
        super(organizationalChart.getProject());
        this.organizationalChart = organizationalChart;
        this.parentOu = parentOu;
    }

    @Override
    public Msg validate(OrganizationalUnit ou) {
        if (Str.isEmpty(ou.getName())) {
            return DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY;
        }
        if (Str.isEmpty(ou.getId())) {
            return DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY;
        }
        if (this.organizationalChart.findOrganizationalUnit(ou.getId()) != null) {
            return DesignerMsg.OBJECT_ALREADY_EXISTS(ProjectMsg.ORGANIZATIONAL_UNIT, ou.getId());
        }
        OrganizationalUnit parent = this.parentOu != null ? this.parentOu : ou.getOrganization().getRootOrganizationalUnit();
        Sequence unitSequence = parent.getChildrenByType(OrganizationalUnit.class);
        for (OrganizationalUnit organizationalUnit : unitSequence) {
            if (!organizationalUnit.getName().equals(ou.getName())) continue;
            return DesignerMsg.ORGANIZATIONAL_UNIT_ALREADY_EXISTS(ou.getName());
        }
        return null;
    }
}

