/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.validator.organization;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.AbstractProjectObjectValidator;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;

public class CalendarRuleExistenceValidator
extends AbstractProjectObjectValidator<CalendarRule> {
    public CalendarRuleExistenceValidator(Project project) {
        super(project);
    }

    @Override
    public Msg validate(CalendarRule calendarRule) {
        String name = calendarRule.getName();
        if (Str.isEmpty(name)) {
            return DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY;
        }
        Organization organization = this.getProject().getOrganization();
        if (organization.findCalendarRule(calendarRule.getId()) != null) {
            return DesignerMsg.OBJECT_ALREADY_EXISTS(ProjectMsg.CALENDAR_RULE, calendarRule.getId());
        }
        if (organization.findCalendarRuleByName(name) != null) {
            return DesignerMsg.OBJECT_ALREADY_EXISTS(ProjectMsg.CALENDAR_RULE, name);
        }
        return null;
    }
}

