/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComposedIcon;
import oracle.bpm.ui.Image;

public class IconFactory {
    private static final Map<Image, Image> readOnlyImages = new WeakHashMap<Image, Image>();
    private static final Map<Image, Image> grayImages = new WeakHashMap<Image, Image>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createGreyIcon(Image image) {
        Map<Image, Image> map = grayImages;
        synchronized (map) {
            Image grayImage = grayImages.get(image);
            if (grayImage == null) {
                grayImage = Image.createGrey((Image)image);
                grayImages.put(image, grayImage);
            }
            return grayImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createReadOnly(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null icon");
        }
        Map<Image, Image> map = readOnlyImages;
        synchronized (map) {
            Image readOnly = readOnlyImages.get(image);
            if (readOnly == null) {
                ArrayList<Image> list = new ArrayList<Image>();
                list.add(image);
                list.add(Image.create((Msg)DesignerMsg.READONLY));
                ComposedIcon c = new ComposedIcon(list);
                readOnly = Image.create((Icon)c);
                readOnlyImages.put(image, readOnly);
            }
            return readOnly;
        }
    }

    public static Image createProcessImageIcon(boolean readOnly) {
        Image result = Image.create((Msg)LibMsg.PROCESS);
        if (readOnly) {
            result = IconFactory.createReadOnly(result);
        }
        return result;
    }

    public static Image createXMasIcon(Image icon) {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(icon);
        list.add(Image.create((Msg)DesignerMsg.XMAS));
        ComposedIcon c = new ComposedIcon(list);
        return Image.create((Icon)c);
    }
}

