/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;

public abstract class TypePanel
extends Panel {
    private ComponentCatalog componentCatalog;
    private boolean initialized;
    private Dialog parentDialog;
    private TypeItem typeItem;
    public static final String TYPE_ITEM_PROPERTY = "oracle.bpm.designer.types.TypeItem";
    public static final String TYPE_ITEM_SELECTED = "type-item-selected";

    public TypePanel(UiContainer parent) {
        super(parent);
    }

    public TypePanel(UiContainer parent, Msg title) {
        super(parent, title);
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setParentDialog(Dialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Dialog getParentDialog() {
        return this.parentDialog;
    }

    public void setSelectionFilter(TypesFilter selectionFilter) {
    }

    public void setTypeCatalog(ComponentCatalog componentCatalog) {
        this.componentCatalog = componentCatalog;
    }

    public ComponentCatalog getTypeCatalog() {
        return this.componentCatalog;
    }

    public void setTypeItem(TypeItem typeItem) {
        this.typeItem = typeItem;
        if (this.isInitialized()) {
            this.updateDefaults();
        }
    }

    public TypeItem getTypeItem() {
        return this.typeItem;
    }

    public void setTypesFilter(TypesFilter typeFilter) {
    }

    public boolean isValidType() {
        return true;
    }

    public void showTypeErrors() {
    }

    protected abstract void initialize();

    protected MutableComponentCatalog getTypeRepository() {
        return (MutableComponentCatalog)this.getTypeCatalog();
    }

    protected void updateDefaults() {
    }

    static String render(TypeDescription type) {
        TypeRenderer typeRenderer = EditorPreferences.getInstance().getTypeRenderer();
        String text = typeRenderer.render((TypeRef)type);
        return text;
    }
}

