/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypeItemId;
import oracle.bpm.designer.types.TypeUtils;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class TypeItemFactory {
    public static Iterable<TypeItem> createPredefinedTypes(int options, boolean isMethod) {
        List<TypeItem> typeItems = CollectionFactory.createList();
        TypeItemFactory.innerCreatePredefinedTypes(options, isMethod, typeItems);
        return typeItems;
    }

    public static List<TypeItem> createAllTypes(int options, boolean isMethod) {
        List<TypeItem> typeItems = CollectionFactory.createList();
        TypeItemFactory.innerCreatePredefinedTypes(options, isMethod, typeItems);
        TypeItemFactory.innerCreateNonPredefinedTypes(options, typeItems);
        return typeItems;
    }

    public static Iterable<TypeItem> createProjectVariableValidTypes() {
        List<TypeItem> typeItems = CollectionFactory.createList();
        TypeItemFactory.innerCreateProjectVariableValidTypes(typeItems);
        return typeItems;
    }

    public static Iterable<TypeItem> createBusinessIndicatorProjectVariableValidTypes() {
        List<TypeItem> typeItems = CollectionFactory.createList();
        TypeItemFactory.innerCreateBIProjectVariableValidTypes(typeItems);
        return typeItems;
    }

    public static Iterable<TypeItem> createCounterProjectVariableValidTypes() {
        List<TypeItem> typeItems = CollectionFactory.createList();
        TypeItemFactory.innerCreateCounterProjectVariableValidTypes(typeItems);
        return typeItems;
    }

    private static void innerCreateBIProjectVariableValidTypes(List<TypeItem> outputItems) {
        TypeItemFactory.addPredefined(TypeItemId.INT, CatalogType.Default.getInt(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.REAL, CatalogType.Default.getReal(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.DECIMAL, CatalogType.Default.getDecimal(), outputItems);
    }

    private static void innerCreateCounterProjectVariableValidTypes(List<TypeItem> outputItems) {
        TypeItemFactory.addPredefined(TypeItemId.INT, CatalogType.Default.getInt(), outputItems);
    }

    private static void innerCreateNonPredefinedTypes(int options, List<TypeItem> outputItems) {
        if ((options & 1) != 0) {
            TypeItemFactory.addComplex(TypeItemId.COMPONENT, DesignerMsg.TYPES_COMPONENT, outputItems);
        }
        if ((options & 2) != 0) {
            TypeItemFactory.addComplex(TypeItemId.ARRAY, DesignerMsg.TYPES_ARRAY, outputItems);
        }
    }

    private static void innerCreatePredefinedTypes(int options, boolean isMethod, List<TypeItem> outputItems) {
        if ((options & 2) != 0) {
            TypeItemFactory.addPredefined(TypeItemId.STRING, CatalogType.Default.getString(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.INT, CatalogType.Default.getInt(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.BOOL, CatalogType.Default.getBool(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.REAL, CatalogType.Default.getReal(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.DECIMAL, CatalogType.Default.getDecimal(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.TIME, CatalogType.Default.getTime(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.INTERVAL, CatalogType.Default.getInterval(), outputItems);
            TypeItemFactory.addPredefined(TypeItemId.BINARY, CatalogType.Default.getBinary(), outputItems);
        }
        if ((options & 4) != 0 || isMethod) {
            TypeItemFactory.addPredefined(TypeItemId.VOID, CatalogType.Default.getVoid(), outputItems);
        }
        if ((options & 8) != 0) {
            TypeItemFactory.addPredefined(TypeItemId.NONE, CatalogType.Default.getNone(), outputItems);
        }
    }

    private static void innerCreateProjectVariableValidTypes(List<TypeItem> outputItems) {
        TypeItemFactory.addPredefined(TypeItemId.STRING, CatalogType.Default.getString(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.INT, CatalogType.Default.getInt(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.BOOL, CatalogType.Default.getBool(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.REAL, CatalogType.Default.getReal(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.DECIMAL, CatalogType.Default.getDecimal(), outputItems);
        TypeItemFactory.addPredefined(TypeItemId.TIME, CatalogType.Default.getTime(), outputItems);
    }

    private static void addComplex(@NotNull TypeItemId typeItemId, @NotNull Msg msg, @NotNull List<TypeItem> output) {
        output.add(new TypeItem(typeItemId, msg));
    }

    private static void addPredefined(@NotNull TypeItemId id, @NotNull CatalogType type, @NotNull List<TypeItem> output) {
        output.add(new TypeItem(id, TypeUtils.renderPrimitiveType(type), type));
    }
}

