/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.designer.types.TypeUtils;
import oracle.bpm.designer.types.TypesProvider;
import oracle.bpm.draw.Color;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeParser;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ModifyEvent;
import oracle.bpm.ui.event.ModifyListener;
import oracle.bpm.ui.event.VisibilityAdapter;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.peer.ComboBoxPeer;

class TypeComboBox
extends ComboBox<CatalogType>
implements PropertyChangeListener {
    private Color INVALID_TYPE_COLOR = Color.RED;
    private final boolean isMethod;
    private CatalogType lastValidType;
    private boolean receivePropertyEventsEnabled = true;
    private ComponentCatalog repository;
    private final int typeOptions;
    private Color VALID_TYPE_COLOR = Color.BLACK;

    protected TypeComboBox(UiContainer parent, ComponentCatalog repository, int typeOptions, boolean isMethod) {
        super(parent, true);
        this.repository = repository;
        this.isMethod = isMethod;
        this.typeOptions = typeOptions;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("language")) {
            try {
                this.receivePropertyEventsEnabled = false;
                int selected = this.getSelectedIndex();
                this.removeAllItems();
                this.addTypes();
                if (selected < this.getItemCount()) {
                    this.setSelectedIndex(selected);
                }
            }
            finally {
                this.receivePropertyEventsEnabled = true;
            }
        }
    }

    public CatalogType getSelectedItem() {
        Object selectedItem = this.getComboBoxPeer().getSelectedItem();
        if (selectedItem instanceof CatalogType) {
            return (CatalogType)selectedItem;
        }
        return this.getInnerSelectedItem(selectedItem);
    }

    public void setSelectedItem(Object item) {
        if (!Any.equals(this.getSelectedItem(), item)) {
            assert (!(item instanceof TypeDescription)) : item;
            if (item != null && item instanceof CatalogType) {
                CatalogType type;
                this.lastValidType = type = ((CatalogType)item).primitiveEquivalent(false);
                if (!this.existItem(type)) {
                    this.addType(type);
                }
                super.setSelectedItem(item);
                this.ensuredSelectionChanged(true, item);
            } else {
                super.setSelectedItem(item);
            }
        }
    }

    protected void ensuredSelectionChanged(boolean fromCombo, Object item) {
    }

    protected void addType(CatalogType type) {
        super.addItem((Object)type.primitiveEquivalent(false));
    }

    protected void addTypes() {
        for (CatalogType type : TypesProvider.getPredefinedTypes(this.typeOptions, this.isMethod)) {
            this.addType(type);
        }
    }

    protected void ensureSelectedItem() {
        CatalogType type = this.getSelectedItem();
        if (type == null && this.lastValidType != null) {
            this.setSelectedItem(this.lastValidType);
        }
    }

    protected boolean isReceivePropertyEventsEnabled() {
        return this.receivePropertyEventsEnabled;
    }

    protected void setReceivePropertyEventsEnabled(boolean receivePropertyEventsEnabled) {
        this.receivePropertyEventsEnabled = receivePropertyEventsEnabled;
    }

    private CatalogType getInnerSelectedItem(Object selectedItem) {
        String selectedString = String.valueOf(selectedItem);
        try {
            LanguageSpec languageSpec = EditorPreferences.getInstance().getLanguageSpec();
            TypeParser typeParser = languageSpec.getTypeParser();
            TypeRef typeRef = typeParser.parse(selectedString, this.repository);
            return CatalogTypeImpl.get((TypeRef)typeRef.get().primitiveEquivalent(false));
        }
        catch (IllegalTypeException e) {
            return null;
        }
    }

    private void init() {
        this.setLabelProvider((LabelProvider)new TypeLabelProvider());
        this.addTypes();
        this.addTypeComboBoxListeners();
        this.setMaximumRowCount(12);
        this.setSelectedIndex(0);
        this.lastValidType = this.getSelectedItem();
        final EditorPreferences prefs = EditorPreferences.getInstance();
        prefs.addListener((PropertyChangeListener)this);
        this.addVisibilityListener((VisibilityListener)new VisibilityAdapter(){

            public void onDispose() {
                prefs.removeListener((PropertyChangeListener)TypeComboBox.this);
            }
        });
    }

    private boolean existItem(CatalogType typeDescription) {
        int itemCount = this.getItemCount();
        CatalogType primitiveEquivalent = typeDescription.primitiveEquivalent(false);
        for (int i = 0; i < itemCount; ++i) {
            CatalogType type = (CatalogType)this.getItemAt(i);
            if (!type.primitiveEquivalent(false).equivalent(primitiveEquivalent)) continue;
            return true;
        }
        return false;
    }

    private void addTypeComboBoxListeners() {
        this.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CatalogType type = TypeComboBox.this.getSelectedItem();
                if (type == null) {
                    TypeComboBox.this.setForegroundColor(TypeComboBox.this.INVALID_TYPE_COLOR);
                } else {
                    TypeComboBox.this.setForegroundColor(TypeComboBox.this.VALID_TYPE_COLOR);
                    TypeComboBox.this.lastValidType = type;
                    TypeComboBox.this.ensuredSelectionChanged(false, type);
                }
            }
        });
    }

    private void setForegroundColor(Color typeComboBoxStatus) {
        this.setForeground(typeComboBoxStatus);
    }

    private ComboBoxPeer getComboBoxPeer() {
        return (ComboBoxPeer)this.getPeer();
    }

    private static class TypeLabelProvider
    extends LabelProvider.Default<CatalogType> {
        private TypeLabelProvider() {
        }

        public String getText(CatalogType type) {
            return TypeUtils.renderType(type);
        }
    }
}

