/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.TypesFilter;
import oracle.bpm.designer.types.TypeComboBox;
import oracle.bpm.designer.types.TypesDialog;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

public class TypeChooserPanel
extends Panel {
    private boolean arraysEnabled = true;
    private Button browseButton;
    private final boolean isMethod;
    private List<EnsuredItemListener<CatalogType>> itemListeners;
    private boolean notifiyEvent = true;
    private Project project;
    private ProjectFilter projectFilter;
    private ComponentCatalog repository;
    private TypesFilter selectionFilter;
    private TypeComboBox typeComboBox;
    private TypesFilter typeFilter;
    private int typeOptions;

    private TypeChooserPanel(UiContainer parent, ComponentCatalog catalog, boolean isMethod, int typeOptions) {
        super(parent);
        this.project = this.project != null ? this.project : FuegoProject.getFrom((TypeRef)catalog.getRoot());
        this.repository = catalog;
        this.isMethod = isMethod;
        this.typeOptions = typeOptions;
        this.itemListeners = new ArrayList<EnsuredItemListener<CatalogType>>();
        this.init();
    }

    private TypeChooserPanel(UiContainer parent, ComponentCatalog catalog, boolean isMethod, int typeOptions, TypesFilter typeFilter, TypesFilter selectionFilter) {
        this(parent, catalog, isMethod, typeOptions);
        this.typeFilter = typeFilter;
        this.selectionFilter = selectionFilter;
    }

    public static TypeChooserPanel create(UiContainer parent, ComponentCatalog repository) {
        return TypeChooserPanel.create(parent, repository, false);
    }

    public static TypeChooserPanel create(UiContainer parent, ComponentCatalog repository, ProjectFilter filter) {
        TypeChooserPanel typeChooserPanel = TypeChooserPanel.create(parent, repository);
        typeChooserPanel.projectFilter = filter;
        return typeChooserPanel;
    }

    public static TypeChooserPanel create(UiContainer parent, ComponentCatalog repository, TypesFilter typesFilter) {
        return TypeChooserPanel.create(parent, repository, false, 3, typesFilter, null);
    }

    public static TypeChooserPanel create(UiContainer parent, ComponentCatalog repository, boolean isMethod) {
        return new TypeChooserPanel(parent, repository, isMethod, 3);
    }

    public static TypeChooserPanel create(UiContainer parent, ComponentCatalog repository, boolean isMethod, int typesDialogOptions, TypesFilter typeFilter, TypesFilter selectionFilter) {
        return new TypeChooserPanel(parent, repository, isMethod, typesDialogOptions, typeFilter, selectionFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialType(CatalogType typeDescription, boolean notifiyEvent) {
        try {
            this.notifiyEvent = notifiyEvent;
            this.typeComboBox.setSelectedItem(typeDescription);
        }
        finally {
            this.notifiyEvent = true;
        }
    }

    public ComponentCatalog getRepository() {
        return this.repository;
    }

    public CatalogType getEnsuredSelectedItem() {
        this.typeComboBox.ensureSelectedItem();
        return this.typeComboBox.getSelectedItem();
    }

    public boolean isValidType() {
        return this.typeComboBox.getSelectedItem() != null;
    }

    public String getInvalidType() {
        return this.typeComboBox.getText();
    }

    public void showBrowseButton(boolean showBrowseButton) {
        this.browseButton.setVisible(showBrowseButton);
    }

    public void dispose() {
        this.itemListeners.clear();
        super.dispose();
    }

    public void addTypedItemListener(EnsuredItemListener<CatalogType> listener) {
        if (listener != null) {
            this.itemListeners.add(listener);
        }
    }

    public void removeTypedItemListener(EnsuredItemListener<CatalogType> listener) {
        if (listener != null && this.itemListeners.contains(listener)) {
            this.itemListeners.remove(listener);
        }
    }

    public boolean containsTypedItemListener(EnsuredItemListener<CatalogType> listener) {
        return this.itemListeners.contains(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.typeComboBox.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public void setArraysEnabled(boolean enabled) {
        this.arraysEnabled = enabled;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        this.typeComboBox = new TypeComboBox((UiContainer)this, this.repository, this.typeOptions, this.isMethod){

            @Override
            protected void ensuredSelectionChanged(boolean fromCombo, Object item) {
                if (TypeChooserPanel.this.notifiyEvent) {
                    TypeChooserPanel.this.notifyItemListeners(fromCombo);
                }
            }
        };
        BaseAction browseAction = new BaseAction(EditorMsg.COMPONENT_PANEL_BROWSE_TYPES){

            public void run() {
                TypeChooserPanel.this.openTypeDialog();
            }
        };
        this.browseButton = new Button((UiContainer)this, browseAction);
        Button.fixSize((Button)this.browseButton);
        this.add((UiComponent)this.typeComboBox, "growx");
        this.add((UiComponent)this.browseButton);
    }

    private void openTypeDialog() {
        TypesDialog typesDialog = new TypesDialog(Ui.getRoot(), this.typeOptions, this.project, this.projectFilter, this.arraysEnabled);
        this.typeComboBox.ensureSelectedItem();
        typesDialog.setTypeCatalog(this.getRepository());
        typesDialog.setArraysEnabled(this.arraysEnabled);
        typesDialog.setTypeFilter(this.typeFilter);
        typesDialog.setSelectionFilter(this.selectionFilter);
        typesDialog.setInitialTypeRef(this.typeComboBox.getSelectedItem());
        typesDialog.setVisible(true);
        if (typesDialog.userAccepted()) {
            CatalogType typeRef = typesDialog.getSelectedTypeItem().getRef();
            this.typeComboBox.setSelectedItem(typeRef);
        }
    }

    private void notifyItemListeners(boolean fromCombo) {
        for (EnsuredItemListener<CatalogType> itemListener : this.itemListeners) {
            itemListener.itemStateChanged(new EnsuredItemEvent(null, this.getEnsuredSelectedItem(), fromCombo));
        }
    }

    public static class EnsuredItemEvent<E> {
        private boolean fromCombo;
        private final E item;
        private final Object source;

        public EnsuredItemEvent(Object source, E item) {
            this(source, item, true);
        }

        private EnsuredItemEvent(Object source, E item, boolean fromCombo) {
            this.source = source;
            this.item = item;
            this.fromCombo = fromCombo;
        }

        public E getItem() {
            return this.item;
        }

        public Object getSource() {
            return this.source;
        }

        public boolean isFromCombo() {
            return this.fromCombo;
        }
    }

    public static interface EnsuredItemListener<E> {
        public void itemStateChanged(EnsuredItemEvent<E> var1);
    }
}

