/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypePanel;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;

public class StringPanel
extends TypePanel
implements ChangeListener,
ActionListener {
    private CheckBox lengthChk;
    private NumericField<Integer> lengthSpn;

    public StringPanel(UiContainer parent) {
        super(parent, DesignerMsg.TYPES_STRING);
    }

    public void actionPerformed(ActionEvent e) {
        this.lengthSpn.setEnabled(this.lengthChk.isSelected());
        if (this.lengthChk.isSelected()) {
            this.stateChanged(null);
        } else {
            this.updateValue();
        }
    }

    public void stateChanged(ChangeEvent e) {
        TypeItem typeItem = this.getTypeItem();
        typeItem.setRef(CatalogType.Default.getString((int)((Integer)this.lengthSpn.getValue())));
        this.firePropertyChange("oracle.bpm.designer.types.TypeItem", null, typeItem);
    }

    @Override
    protected void initialize() {
        this.setLayout((Layout)new BorderLayout());
        Panel panel = new Panel((UiContainer)this);
        this.lengthSpn = NumericField.createIntegerNumericField((UiContainer)panel);
        this.lengthSpn.setValue((Number)10);
        this.lengthSpn.setRange((Number)0, (Number)10000);
        this.lengthSpn.setStepSize((Number)1);
        this.lengthSpn.addChangeListener((ChangeListener)this);
        this.lengthChk = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.MAX_STRING_LENGTH);
        this.lengthChk.addActionListener((ActionListener)this);
        FormLayout layout = new FormLayout("1dlu, pref, 1dlu, default, 1dlu", "pref");
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.lengthChk, cc.xy(2, 1));
        builder.add(this.lengthSpn, cc.xy(4, 1));
        this.add((UiComponent)panel, "Center");
        this.setInitialized(true);
        this.updateDefaults();
    }

    @Override
    protected void updateDefaults() {
        TypeItem typeItem = this.getTypeItem();
        CatalogType typeRef = typeItem.getRef();
        if (typeRef != null) {
            int length = typeRef.getLength();
            if (length != -1) {
                this.lengthChk.setSelected(true);
                this.lengthSpn.setEnabled(true);
                this.lengthSpn.setValue((Number)length);
            } else {
                this.lengthChk.setSelected(false);
                this.lengthSpn.setEnabled(false);
            }
        } else {
            typeItem.setRef(CatalogType.Default.getString());
            this.lengthChk.setSelected(false);
            this.lengthSpn.setEnabled(false);
        }
    }

    private void updateValue() {
        TypeItem typeItem = this.getTypeItem();
        typeItem.setRef(CatalogType.Default.getString());
        this.firePropertyChange("oracle.bpm.designer.types.TypeItem", null, typeItem);
    }
}

