/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import oracle.bpm.designer.types.CILTypeComboBox;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypesDialog;
import oracle.bpm.editor.msg.EditorMsg;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;

public class DetailedCILTypeComboBox
extends CILTypeComboBox {
    private Project project;
    private ComponentCatalog repository;

    public DetailedCILTypeComboBox(UiContainer parent, ComponentCatalog repository) {
        this(parent, null, repository, false);
    }

    public DetailedCILTypeComboBox(UiContainer parent, Project project, ComponentCatalog catalog, boolean isMethod) {
        super(parent, isMethod);
        this.project = project != null ? project : FuegoProject.getFrom((TypeRef)catalog.getRoot());
        this.init(catalog);
    }

    public Button getBrowseButton(UiContainer parent) {
        BaseAction browseAction = new BaseAction(EditorMsg.COMPONENT_PANEL_BROWSE_TYPES){

            public void run() {
                DetailedCILTypeComboBox.this.openTypeDialog();
            }
        };
        return new Button(parent, browseAction);
    }

    public ComponentCatalog getRepository() {
        return this.repository;
    }

    protected TypesDialog getTypesDialog() {
        TypesDialog typesDialog = new TypesDialog(Ui.getRoot(), this.project);
        typesDialog.setTypeCatalog(this.getTypeRepository());
        return typesDialog;
    }

    private void init(ComponentCatalog repository) {
        this.repository = repository;
    }

    private ComponentCatalog getTypeRepository() {
        return this.repository;
    }

    private void openTypeDialog() {
        TypesDialog typesDialog = this.getTypesDialog();
        CatalogType type = ((TypeItem)this.getSelectedItem()).getRef();
        typesDialog.setInitialTypeRef(type);
        typesDialog.setVisible(true);
        if (typesDialog.userAccepted()) {
            CatalogType result = typesDialog.getSelectedTypeItem().getRef();
            this.setSelectedItem(result);
        }
    }
}

